/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.python;

import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.ExternalTransforms;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.python.PythonExternalTransform;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.schemas.logicaltypes.MicrosInstant;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.UsesPythonExpansionService;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Keys;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.PythonCallableSource;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PythonExternalTransformTest
implements Serializable {
    @Test
    @Category(value={ValidatesRunner.class, UsesPythonExpansionService.class})
    public void trivialPythonTransform() {
        Pipeline p = Pipeline.create();
        PCollection output = (PCollection)((PCollection)((PCollection)p.apply((PTransform)Create.of((Object)KV.of((Object)"A", (Object)"x"), (Object[])new KV[]{KV.of((Object)"A", (Object)"y"), KV.of((Object)"B", (Object)"z")}))).apply((PTransform)PythonExternalTransform.from((String)"apache_beam.GroupByKey"))).apply((PTransform)Keys.create());
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"A", "B"});
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesPythonExpansionService.class})
    public void pythonTransformWithDependencies() {
        Pipeline p = Pipeline.create();
        PCollection output = (PCollection)((PCollection)p.apply((PTransform)Create.of((Object)"elephant", (Object[])new String[]{"mouse", "sheep"}))).apply((PTransform)PythonExternalTransform.from((String)"apache_beam.Map").withArgs(new Object[]{PythonCallableSource.of((String)"import inflection\ninflection.pluralize")}).withExtraPackages((List)ImmutableList.of((Object)"inflection")).withOutputCoder((Coder)StringUtf8Coder.of()));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new String[]{"elephants", "mice", "sheep"});
    }

    @Test
    public void generateArgsEmpty() {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform");
        Row receivedRow = transform.buildOrGetArgsRow();
        Assert.assertEquals((long)0L, (long)receivedRow.getFieldCount());
    }

    @Test
    public void generateArgsWithPrimitives() {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withArgs(new Object[]{"aaa", "bbb", 11, 12L, 15.6, true});
        Schema expectedSchema = Schema.builder().addStringField("field0").addStringField("field1").addInt32Field("field2").addInt64Field("field3").addDoubleField("field4").addBooleanField("field5").build();
        Row expectedRow = Row.withSchema((Schema)expectedSchema).addValues(new Object[]{"aaa", "bbb", 11, 12L, 15.6, true}).build();
        Row receivedRow = transform.buildOrGetArgsRow();
        Assert.assertEquals((Object)expectedRow, (Object)receivedRow);
    }

    @Test
    public void generateArgsWithRow() {
        Schema subRowSchema1 = Schema.builder().addStringField("field0").addInt32Field("field1").build();
        Row rowField1 = Row.withSchema((Schema)subRowSchema1).addValues(new Object[]{"xxx", 123}).build();
        Schema subRowSchema2 = Schema.builder().addDoubleField("field0").addBooleanField("field1").addStringField("field2").build();
        Row rowField2 = Row.withSchema((Schema)subRowSchema2).addValues(new Object[]{12.5, true, "yyy"}).build();
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withArgs(new Object[]{rowField1, rowField2});
        Schema expectedSchema = Schema.builder().addRowField("field0", subRowSchema1).addRowField("field1", subRowSchema2).build();
        Row expectedRow = Row.withSchema((Schema)expectedSchema).addValues(new Object[]{rowField1, rowField2}).build();
        Row receivedRow = transform.buildOrGetArgsRow();
        Assert.assertEquals((Object)expectedRow, (Object)receivedRow);
    }

    @Test
    public void generatePayloadWithoutKwargs() throws Exception {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withArgs(new Object[]{"aaa", "bbb", 11, 12L, 15.6, true});
        ExternalTransforms.ExternalConfigurationPayload payload = transform.generatePayload();
        Schema schema = SchemaTranslation.schemaFromProto((SchemaApi.Schema)payload.getSchema());
        Assert.assertTrue((boolean)schema.hasField("args"));
        Assert.assertFalse((boolean)schema.hasField("kwargs"));
    }

    @Test
    public void generatePayloadWithoutArgs() {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withKwarg("stringField1", (Object)"aaa").withKwarg("stringField2", (Object)"bbb").withKwarg("intField", (Object)11).withKwarg("longField", (Object)12L).withKwarg("doubleField", (Object)15.6).withKwarg("boolField", (Object)true);
        ExternalTransforms.ExternalConfigurationPayload payload = transform.generatePayload();
        Schema schema = SchemaTranslation.schemaFromProto((SchemaApi.Schema)payload.getSchema());
        Assert.assertFalse((boolean)schema.hasField("args"));
        Assert.assertTrue((boolean)schema.hasField("kwargs"));
    }

    @Test
    public void generateArgsWithCustomType() {
        CustomType customType1 = new CustomType();
        customType1.strField = "xxx";
        customType1.intField = 123;
        CustomType customType2 = new CustomType();
        customType2.strField = "yyy";
        customType2.intField = 456;
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withArgs(new Object[]{customType1, customType2});
        Row receivedRow = transform.buildOrGetArgsRow();
        Assert.assertEquals((Object)"xxx", (Object)receivedRow.getRow("field0").getString("strField"));
        Assert.assertEquals((long)123L, (long)receivedRow.getRow("field0").getInt32("intField").intValue());
        Assert.assertEquals((Object)"yyy", (Object)receivedRow.getRow("field1").getString("strField"));
        Assert.assertEquals((long)456L, (long)receivedRow.getRow("field1").getInt32("intField").intValue());
    }

    @Test
    public void generateArgsWithPythonCallableSource() {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withArgs(new Object[]{PythonCallableSource.of((String)"dummy data")});
        Row receivedRow = transform.buildOrGetArgsRow();
        Assert.assertTrue((boolean)(receivedRow.getValue("field0") instanceof PythonCallableSource));
    }

    @Test
    public void generateArgsWithTypeHint() {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withArgs(new Object[]{Instant.ofEpochSecond(0L)}).withTypeHint(Instant.class, Schema.FieldType.logicalType((Schema.LogicalType)new MicrosInstant()));
        Row receivedRow = transform.buildOrGetArgsRow();
        Assert.assertTrue((boolean)(receivedRow.getValue("field0") instanceof Instant));
    }

    @Test
    public void generateKwargsEmpty() {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform");
        Row receivedRow = transform.buildOrGetKwargsRow();
        Assert.assertEquals((long)0L, (long)receivedRow.getFieldCount());
    }

    @Test
    public void generateKwargsWithPrimitives() {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withKwarg("stringField1", (Object)"aaa").withKwarg("stringField2", (Object)"bbb").withKwarg("intField", (Object)11).withKwarg("longField", (Object)12L).withKwarg("doubleField", (Object)15.6).withKwarg("boolField", (Object)true);
        Row receivedRow = transform.buildOrGetKwargsRow();
        Assert.assertEquals((Object)"aaa", (Object)receivedRow.getString("stringField1"));
        Assert.assertEquals((Object)"bbb", (Object)receivedRow.getString("stringField2"));
        Assert.assertEquals((long)11L, (long)receivedRow.getInt32("intField").intValue());
        Assert.assertEquals((long)12L, (long)receivedRow.getInt64("longField"));
        Assert.assertEquals((double)15.6, (double)receivedRow.getDouble("doubleField"), (double)0.0);
        Assert.assertEquals((Object)true, (Object)receivedRow.getBoolean("boolField"));
    }

    @Test
    public void generateKwargsRow() {
        Schema subRowSchema1 = Schema.builder().addStringField("field0").addInt32Field("field1").build();
        Row rowField1 = Row.withSchema((Schema)subRowSchema1).addValues(new Object[]{"xxx", 123}).build();
        Schema subRowSchema2 = Schema.builder().addDoubleField("field0").addBooleanField("field1").addStringField("field2").build();
        Row rowField2 = Row.withSchema((Schema)subRowSchema2).addValues(new Object[]{12.5, true, "yyy"}).build();
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withKwarg("customField0", (Object)rowField1).withKwarg("customField1", (Object)rowField2);
        Schema expectedSchema = Schema.builder().addRowField("customField0", subRowSchema1).addRowField("customField1", subRowSchema2).build();
        Row expectedRow = Row.withSchema((Schema)expectedSchema).addValues(new Object[]{rowField1, rowField2}).build();
        Row receivedRow = transform.buildOrGetKwargsRow();
        Assert.assertEquals((Object)expectedRow, (Object)receivedRow);
    }

    @Test
    public void generateKwargsWithCustomType() {
        CustomType customType1 = new CustomType();
        customType1.strField = "xxx";
        customType1.intField = 123;
        CustomType customType2 = new CustomType();
        customType2.strField = "yyy";
        customType2.intField = 456;
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withKwarg("customField0", (Object)customType1).withKwarg("customField1", (Object)customType2);
        Row receivedRow = transform.buildOrGetKwargsRow();
        Assert.assertEquals((Object)"xxx", (Object)receivedRow.getRow("customField0").getString("strField"));
        Assert.assertEquals((long)123L, (long)receivedRow.getRow("customField0").getInt32("intField").intValue());
        Assert.assertEquals((Object)"yyy", (Object)receivedRow.getRow("customField1").getString("strField"));
        Assert.assertEquals((long)456L, (long)receivedRow.getRow("customField1").getInt32("intField").intValue());
    }

    @Test
    public void generateKwargsWithPythonCallableSource() {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withKwarg("customField0", (Object)PythonCallableSource.of((String)"dummy data"));
        Row receivedRow = transform.buildOrGetKwargsRow();
        Assert.assertTrue((boolean)(receivedRow.getValue("customField0") instanceof PythonCallableSource));
    }

    @Test
    public void generateKwargsWithTypeHint() {
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withKwarg("customField0", (Object)Instant.ofEpochSecond(0L)).withTypeHint(Instant.class, Schema.FieldType.logicalType((Schema.LogicalType)new MicrosInstant()));
        Row receivedRow = transform.buildOrGetKwargsRow();
        Assert.assertTrue((boolean)(receivedRow.getValue("customField0") instanceof Instant));
    }

    @Test
    public void generateKwargsFromMap() {
        ImmutableMap kwargsMap = ImmutableMap.of((Object)"stringField1", (Object)"aaa", (Object)"stringField2", (Object)"bbb", (Object)"intField", (Object)11, (Object)"longField", (Object)12L, (Object)"doubleField", (Object)15.6);
        PythonExternalTransform transform = PythonExternalTransform.from((String)"DummyTransform").withKwargs((Map)kwargsMap);
        Row receivedRow = transform.buildOrGetKwargsRow();
        Assert.assertEquals((Object)"aaa", (Object)receivedRow.getString("stringField1"));
        Assert.assertEquals((Object)"bbb", (Object)receivedRow.getString("stringField2"));
        Assert.assertEquals((long)11L, (long)receivedRow.getInt32("intField").intValue());
        Assert.assertEquals((long)12L, (long)receivedRow.getInt64("longField"));
        Assert.assertEquals((double)15.6, (double)receivedRow.getDouble("doubleField"), (double)0.0);
    }

    static class CustomType {
        int intField;
        String strField;

        CustomType() {
        }
    }
}

