/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.beam.sdk.extensions.protobuf.Proto2SchemaMessages;
import org.apache.beam.sdk.extensions.protobuf.Proto3SchemaMessages;
import org.apache.beam.sdk.extensions.protobuf.ProtoMessageSchema;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaTranslator;
import org.apache.beam.sdk.extensions.protobuf.TestProtoSchemas;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoSchemaTranslatorTest {
    @Test
    public void testPrimitiveSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.PRIMITIVE_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.Primitive.class));
    }

    @Test
    public void testOptionalPrimitiveSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.OPTIONAL_PRIMITIVE_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto2SchemaMessages.OptionalPrimitive.class));
    }

    @Test
    public void testRequiredPrimitiveSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.REQUIRED_PRIMITIVE_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto2SchemaMessages.RequiredPrimitive.class));
    }

    @Test
    public void testRepeatedSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.REPEATED_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.RepeatPrimitive.class));
    }

    @Test
    public void testMapPrimitiveSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.MAP_PRIMITIVE_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.MapPrimitive.class));
    }

    @Test
    public void testNestedSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.NESTED_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.Nested.class));
    }

    @Test
    public void testOneOfSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OneOf.class));
    }

    @Test
    public void testReversedOneOfSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.ReversedOneOf.class));
    }

    @Test
    public void testNonContiguousOneOfSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.NONCONTIGUOUS_ONEOF_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.NonContiguousOneOf.class));
    }

    @Test
    public void testNestedOneOfSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.OUTER_ONEOF_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OuterOneOf.class));
    }

    @Test
    public void testWrapperMessagesSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.WKT_MESSAGE_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.WktMessage.class));
    }

    @Test
    public void testEmptySchema() {
        Assert.assertEquals((Object)TestProtoSchemas.EMPTY_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.Empty.class));
    }

    @Test
    public void testSelfNestedProtoThrows() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.SelfNested.class)));
        MatcherAssert.assertThat((String)"Message should suggest not using a circular schema reference.", (Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"circular reference"));
        MatcherAssert.assertThat((String)"Message should suggest which class has circular schema reference.", (Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"proto3_schema_messages.SelfNested"));
    }

    @Test
    public void testCircularNestedProtoThrows() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.FirstCircularNested.class)));
        MatcherAssert.assertThat((String)"Message should suggest not using a circular schema reference.", (Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"circular reference"));
        MatcherAssert.assertThat((String)"Message should suggest which class has circular schema reference.", (Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"proto3_schema_messages.FirstCircularNested"));
    }

    @Test
    public void testOptionalNestedSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.OPTIONAL_NESTED_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto2SchemaMessages.OptionalNested.class));
    }

    @Test
    public void testRequiredNestedSchema() {
        Assert.assertEquals((Object)TestProtoSchemas.REQUIRED_NESTED_SCHEMA, (Object)ProtoSchemaTranslator.getSchema(Proto2SchemaMessages.RequiredNested.class));
    }

    @Test
    public void testOptionsInt32OnMessage() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        Assert.assertEquals((Object)42, (Object)schema.getOptions().getValue("beam:option:proto:message:proto3_schema_options.message_option_int"));
    }

    @Test
    public void testOptionsStringOnMessage() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        Assert.assertEquals((Object)"this is a message string", (Object)schema.getOptions().getValue("beam:option:proto:message:proto3_schema_options.message_option_string"));
    }

    @Test
    public void testOptionsMessageOnMessage() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        Row optionMessage = (Row)schema.getOptions().getValue("beam:option:proto:message:proto3_schema_options.message_option_message");
        Assert.assertEquals((Object)"foobar in message", (Object)optionMessage.getString("single_string"));
        Assert.assertEquals((Object)12, (Object)optionMessage.getInt32("single_int32"));
        Assert.assertEquals((Object)34L, (Object)optionMessage.getInt64("single_int64"));
    }

    @Test
    public void testOptionArrayOnMessage() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        ArrayList verify = new ArrayList((Collection)schema.getOptions().getValue("beam:option:proto:message:proto3_schema_options.message_option_repeated"));
        Assert.assertEquals((Object)"string_1", verify.get(0));
        Assert.assertEquals((Object)"string_2", verify.get(1));
        Assert.assertEquals((Object)"string_3", verify.get(2));
    }

    @Test
    public void testOptionArrayOfMessagesOnMessage() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        ArrayList verify = new ArrayList((Collection)schema.getOptions().getValue("beam:option:proto:message:proto3_schema_options.message_option_repeated_message"));
        Assert.assertEquals((Object)"string in message in option in message", (Object)((Row)verify.get(0)).getString("single_string"));
        Assert.assertEquals((Object)1, (Object)((Row)verify.get(1)).getInt32("single_int32"));
        Assert.assertEquals((Object)2L, (Object)((Row)verify.get(2)).getInt64("single_int64"));
    }

    @Test
    public void testOptionsInt32OnField() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        Schema.Options options = schema.getField("field_one").getOptions();
        Assert.assertEquals((Object)13, (Object)options.getValue("beam:option:proto:field:proto3_schema_options.field_option_int"));
    }

    @Test
    public void testOptionsStringOnField() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        Schema.Options options = schema.getField("field_one").getOptions();
        Assert.assertEquals((Object)"this is a field string", (Object)options.getValue("beam:option:proto:field:proto3_schema_options.field_option_string"));
    }

    @Test
    public void testOptionsMessageOnField() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        Schema.Options options = schema.getField("field_one").getOptions();
        Row optionMessage = (Row)options.getValue("beam:option:proto:field:proto3_schema_options.field_option_message");
        Assert.assertEquals((Object)"foobar in field", (Object)optionMessage.getString("single_string"));
        Assert.assertEquals((Object)56, (Object)optionMessage.getInt32("single_int32"));
        Assert.assertEquals((Object)78L, (Object)optionMessage.getInt64("single_int64"));
    }

    @Test
    public void testOptionArrayOnField() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        Schema.Options options = schema.getField("field_one").getOptions();
        ArrayList verify = new ArrayList((Collection)options.getValue("beam:option:proto:field:proto3_schema_options.field_option_repeated"));
        Assert.assertEquals((Object)"field_string_1", verify.get(0));
        Assert.assertEquals((Object)"field_string_2", verify.get(1));
        Assert.assertEquals((Object)"field_string_3", verify.get(2));
    }

    @Test
    public void testOptionArrayOfMessagesOnField() {
        Schema schema = ProtoSchemaTranslator.getSchema(Proto3SchemaMessages.OptionMessage.class);
        Schema.Options options = schema.getField("field_one").getOptions();
        ArrayList verify = new ArrayList((Collection)options.getValue("beam:option:proto:field:proto3_schema_options.field_option_repeated_message"));
        Assert.assertEquals((Object)"string in message in option in field", (Object)((Row)verify.get(0)).getString("single_string"));
        Assert.assertEquals((Object)77, (Object)((Row)verify.get(1)).getInt32("single_int32"));
        Assert.assertEquals((Object)88L, (Object)((Row)verify.get(2)).getInt64("single_int64"));
    }
}

