/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import java.util.Map;
import org.apache.beam.sdk.extensions.protobuf.PayloadMessages;
import org.apache.beam.sdk.extensions.protobuf.ProtoPayloadSerializerProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoPayloadSerializerProviderTest {
    private static final Schema SHUFFLED_SCHEMA = Schema.builder().addStringField("f_string").addInt32Field("f_int").addArrayField("f_float_array", Schema.FieldType.FLOAT).addDoubleField("f_double").addInt64Field("f_long").build();
    private static final Row ROW = Row.withSchema((Schema)SHUFFLED_SCHEMA).withFieldValue("f_string", (Object)"string").withFieldValue("f_int", (Object)123).withFieldValue("f_float_array", (Object)ImmutableList.of((Object)Float.valueOf(8.0f))).withFieldValue("f_double", (Object)9.0).withFieldValue("f_long", (Object)456L).build();
    private static final PayloadMessages.TestMessage MESSAGE = PayloadMessages.TestMessage.newBuilder().setFLong(456L).setFInt(123).setFDouble(9.0).setFString("string").addFFloatArray(8.0f).build();
    private final ProtoPayloadSerializerProvider provider = new ProtoPayloadSerializerProvider();

    @Test
    public void invalidArgs() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.provider.getSerializer(SHUFFLED_SCHEMA, (Map)ImmutableMap.of()));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.provider.getSerializer(SHUFFLED_SCHEMA, (Map)ImmutableMap.of((Object)"protoClass", (Object)"")));
        Assert.assertThrows(ClassCastException.class, () -> this.provider.getSerializer(SHUFFLED_SCHEMA, (Map)ImmutableMap.of((Object)"protoClass", (Object)ImmutableList.class.getName())));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.provider.getSerializer(Schema.builder().addStringField("f_NOTACTUALLYINMESSAGE").addInt32Field("f_int").addArrayField("f_float_array", Schema.FieldType.FLOAT).addDoubleField("f_double").addInt64Field("f_long").build(), (Map)ImmutableMap.of((Object)"protoClass", (Object)PayloadMessages.TestMessage.class.getName())));
    }

    @Test
    public void serialize() throws Exception {
        byte[] bytes = this.provider.getSerializer(SHUFFLED_SCHEMA, (Map)ImmutableMap.of((Object)"protoClass", (Object)PayloadMessages.TestMessage.class.getName())).serialize(ROW);
        PayloadMessages.TestMessage result = PayloadMessages.TestMessage.parseFrom(bytes);
        Assert.assertEquals((Object)MESSAGE, (Object)result);
    }

    @Test
    public void deserialize() {
        Row row = this.provider.getSerializer(SHUFFLED_SCHEMA, (Map)ImmutableMap.of((Object)"protoClass", (Object)PayloadMessages.TestMessage.class.getName())).deserialize(MESSAGE.toByteArray());
        Assert.assertEquals((Object)ROW, (Object)row);
    }
}

