/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import java.util.Map;
import org.apache.beam.sdk.extensions.protobuf.Proto2SchemaMessages;
import org.apache.beam.sdk.extensions.protobuf.Proto3SchemaMessages;
import org.apache.beam.sdk.extensions.protobuf.ProtoMessageSchema;
import org.apache.beam.sdk.extensions.protobuf.TestProtoSchemas;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoMessageSchemaTest {
    private static final EnumerationType ENUM_TYPE = EnumerationType.create((Map)ImmutableMap.of((Object)"ZERO", (Object)0, (Object)"TWO", (Object)2, (Object)"THREE", (Object)3));
    private static final Schema ENUM_SCHEMA = Schema.builder().addField(TestProtoSchemas.withFieldNumber("enum", Schema.FieldType.logicalType((Schema.LogicalType)ENUM_TYPE), 1)).setOptions(TestProtoSchemas.withTypeName("proto3_schema_messages.EnumMessage")).build();
    private static final Row ENUM_ROW = Row.withSchema((Schema)ENUM_SCHEMA).addValues(new Object[]{ENUM_TYPE.valueOf("TWO")}).build();
    private static final Proto3SchemaMessages.EnumMessage ENUM_PROTO = Proto3SchemaMessages.EnumMessage.newBuilder().setEnum(Proto3SchemaMessages.EnumMessage.Enum.TWO).build();

    @Test
    public void testPrimitiveSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.Primitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.PRIMITIVE_SCHEMA, (Object)schema);
    }

    @Test
    public void testPrimitiveProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.Primitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.PRIMITIVE_ROW, (Object)toRow.apply((Object)TestProtoSchemas.PRIMITIVE_PROTO));
    }

    @Test
    public void testPrimitiveRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.Primitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.PRIMITIVE_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.PRIMITIVE_ROW));
    }

    @Test
    public void testOptionalPrimitiveSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto2SchemaMessages.OptionalPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.OPTIONAL_PRIMITIVE_SCHEMA, (Object)schema);
    }

    @Test
    public void testOptionalPrimitiveProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto2SchemaMessages.OptionalPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.OPTIONAL_PRIMITIVE_ROW, (Object)toRow.apply((Object)TestProtoSchemas.OPTIONAL_PRIMITIVE_PROTO));
    }

    @Test
    public void testOptionalPrimitiveRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto2SchemaMessages.OptionalPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.OPTIONAL_PRIMITIVE_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.OPTIONAL_PRIMITIVE_ROW));
    }

    @Test
    public void testRequiredPrimitiveSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto2SchemaMessages.RequiredPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.REQUIRED_PRIMITIVE_SCHEMA, (Object)schema);
    }

    @Test
    public void testRequiredPrimitiveProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto2SchemaMessages.RequiredPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.REQUIRED_PRIMITIVE_ROW, (Object)toRow.apply((Object)TestProtoSchemas.REQUIRED_PRIMITIVE_PROTO));
    }

    @Test
    public void testRequiredPrimitiveRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto2SchemaMessages.RequiredPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.REQUIRED_PRIMITIVE_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.REQUIRED_PRIMITIVE_ROW));
    }

    @Test
    public void testRepeatedSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.RepeatPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.REPEATED_SCHEMA, (Object)schema);
    }

    @Test
    public void testRepeatedProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.RepeatPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.REPEATED_ROW, (Object)toRow.apply((Object)TestProtoSchemas.REPEATED_PROTO));
    }

    @Test
    public void testRepeatedRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.RepeatPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.REPEATED_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.REPEATED_ROW));
    }

    @Test
    public void testNullRepeatedProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.RepeatPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.NULL_REPEATED_ROW, (Object)toRow.apply((Object)TestProtoSchemas.NULL_REPEATED_PROTO));
    }

    @Test
    public void testNullRepeatedRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.RepeatPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.NULL_REPEATED_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.NULL_REPEATED_ROW));
    }

    @Test
    public void testMapSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.MapPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.MAP_PRIMITIVE_SCHEMA, (Object)schema);
    }

    @Test
    public void testMapProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.MapPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.MAP_PRIMITIVE_ROW, (Object)toRow.apply((Object)TestProtoSchemas.MAP_PRIMITIVE_PROTO));
    }

    @Test
    public void testMapRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.MapPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.MAP_PRIMITIVE_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.MAP_PRIMITIVE_ROW));
    }

    @Test
    public void testNullMapProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.MapPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.NULL_MAP_PRIMITIVE_ROW, (Object)toRow.apply((Object)TestProtoSchemas.NULL_MAP_PRIMITIVE_PROTO));
    }

    @Test
    public void testNullMapRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.MapPrimitive.class));
        Assert.assertEquals((Object)TestProtoSchemas.NULL_MAP_PRIMITIVE_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.NULL_MAP_PRIMITIVE_ROW));
    }

    @Test
    public void testNestedSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.Nested.class));
        Assert.assertEquals((Object)TestProtoSchemas.NESTED_SCHEMA, (Object)schema);
    }

    @Test
    public void testNestedProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.Nested.class));
        Assert.assertEquals((Object)TestProtoSchemas.NESTED_ROW, (Object)toRow.apply((Object)TestProtoSchemas.NESTED_PROTO));
    }

    @Test
    public void testNestedRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.Nested.class));
        Assert.assertEquals((Object)TestProtoSchemas.NESTED_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.NESTED_ROW));
    }

    @Test
    public void testOneOfSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.OneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_SCHEMA, (Object)schema);
    }

    @Test
    public void testOneOfProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.OneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_ROW_INT32, (Object)toRow.apply((Object)TestProtoSchemas.ONEOF_PROTO_INT32));
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_ROW_BOOL, (Object)toRow.apply((Object)TestProtoSchemas.ONEOF_PROTO_BOOL));
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_ROW_STRING, (Object)toRow.apply((Object)TestProtoSchemas.ONEOF_PROTO_STRING));
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_ROW_PRIMITIVE, (Object)toRow.apply((Object)TestProtoSchemas.ONEOF_PROTO_PRIMITIVE));
    }

    @Test
    public void testOneOfRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.OneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_PROTO_INT32, (Object)fromRow.apply((Object)TestProtoSchemas.ONEOF_ROW_INT32));
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_PROTO_BOOL, (Object)fromRow.apply((Object)TestProtoSchemas.ONEOF_ROW_BOOL));
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_PROTO_STRING, (Object)fromRow.apply((Object)TestProtoSchemas.ONEOF_ROW_STRING));
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_PROTO_PRIMITIVE, (Object)fromRow.apply((Object)TestProtoSchemas.ONEOF_ROW_PRIMITIVE));
    }

    @Test
    public void testOuterOneOfSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.OuterOneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.OUTER_ONEOF_SCHEMA, (Object)schema);
    }

    @Test
    public void testOuterOneOfProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.OuterOneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.OUTER_ONEOF_ROW, (Object)toRow.apply((Object)TestProtoSchemas.OUTER_ONEOF_PROTO));
    }

    @Test
    public void testOuterOneOfRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.OuterOneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.OUTER_ONEOF_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.OUTER_ONEOF_ROW));
    }

    @Test
    public void testReversedOneOfProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.ReversedOneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_INT32, (Object)toRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_INT32));
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_BOOL, (Object)toRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_BOOL));
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_STRING, (Object)toRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_STRING));
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_PRIMITIVE, (Object)toRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_PRIMITIVE));
    }

    @Test
    public void testReversedOneOfRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.ReversedOneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_INT32, (Object)fromRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_INT32));
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_BOOL, (Object)fromRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_BOOL));
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_STRING, (Object)fromRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_STRING));
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_PRIMITIVE, (Object)fromRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_PRIMITIVE));
    }

    @Test
    public void testNonContiguousOneOfProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.NonContiguousOneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.NONCONTIGUOUS_ONEOF_ROW, (Object)toRow.apply((Object)TestProtoSchemas.NONCONTIGUOUS_ONEOF_PROTO));
    }

    @Test
    public void testNonContiguousOneOfRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.NonContiguousOneOf.class));
        Assert.assertEquals((Object)TestProtoSchemas.NONCONTIGUOUS_ONEOF_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.NONCONTIGUOUS_ONEOF_ROW));
    }

    @Test
    public void testEnumSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.EnumMessage.class));
        Assert.assertEquals((Object)ENUM_SCHEMA, (Object)schema);
    }

    @Test
    public void testEnumProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.EnumMessage.class));
        Assert.assertEquals((Object)ENUM_ROW, (Object)toRow.apply((Object)ENUM_PROTO));
    }

    @Test
    public void testEnumRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.EnumMessage.class));
        Assert.assertEquals((Object)ENUM_PROTO, (Object)fromRow.apply((Object)ENUM_ROW));
    }

    @Test
    public void testWktMessageSchema() {
        Schema schema = new ProtoMessageSchema().schemaFor(TypeDescriptor.of(Proto3SchemaMessages.WktMessage.class));
        Assert.assertEquals((Object)TestProtoSchemas.WKT_MESSAGE_SCHEMA, (Object)schema);
    }

    @Test
    public void testWktProtoToRow() {
        SerializableFunction toRow = new ProtoMessageSchema().toRowFunction(TypeDescriptor.of(Proto3SchemaMessages.WktMessage.class));
        Assert.assertEquals((Object)TestProtoSchemas.WKT_MESSAGE_ROW, (Object)toRow.apply((Object)TestProtoSchemas.WKT_MESSAGE_PROTO));
    }

    @Test
    public void testWktRowToProto() {
        SerializableFunction fromRow = new ProtoMessageSchema().fromRowFunction(TypeDescriptor.of(Proto3SchemaMessages.WktMessage.class));
        Assert.assertEquals((Object)TestProtoSchemas.WKT_MESSAGE_PROTO, (Object)fromRow.apply((Object)TestProtoSchemas.WKT_MESSAGE_ROW));
    }

    @Test
    public void testRowToBytesAndBytesToRowFn() {
        Assert.assertEquals((Object)TestProtoSchemas.WKT_MESSAGE_ROW, (Object)this.convertRow(TestProtoSchemas.WKT_MESSAGE_ROW));
    }

    @Test
    public void testRowToBytesAndBytesToRowFnWithShuffledFields() {
        Assert.assertEquals((Object)TestProtoSchemas.WKT_MESSAGE_ROW, (Object)this.convertRow(TestProtoSchemas.WKT_MESSAGE_SHUFFLED_ROW));
    }

    private Row convertRow(Row row) {
        SimpleFunction rowToBytes = ProtoMessageSchema.getRowToProtoBytesFn(Proto3SchemaMessages.WktMessage.class);
        SimpleFunction bytesToRow = ProtoMessageSchema.getProtoBytesToRowFn(Proto3SchemaMessages.WktMessage.class);
        byte[] rowInProtoBytes = (byte[])rowToBytes.apply((Object)row);
        return (Row)bytesToRow.apply((Object)rowInProtoBytes);
    }
}

