/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.util.Map;
import org.apache.beam.sdk.extensions.protobuf.Proto3SchemaMessages;
import org.apache.beam.sdk.extensions.protobuf.ProtoDomain;
import org.apache.beam.sdk.extensions.protobuf.ProtoDynamicMessageSchema;
import org.apache.beam.sdk.extensions.protobuf.TestProtoSchemas;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoDynamicMessageSchemaTest {
    private static final EnumerationType ENUM_TYPE = EnumerationType.create((Map)ImmutableMap.of((Object)"ZERO", (Object)0, (Object)"TWO", (Object)2, (Object)"THREE", (Object)3));
    private static final Schema ENUM_SCHEMA = Schema.builder().addField(TestProtoSchemas.withFieldNumber("enum", Schema.FieldType.logicalType((Schema.LogicalType)ENUM_TYPE), 1).withNullable(false)).setOptions(TestProtoSchemas.withTypeName("proto3_schema_messages.EnumMessage")).build();
    private static final Row ENUM_ROW = Row.withSchema((Schema)ENUM_SCHEMA).addValues(new Object[]{ENUM_TYPE.valueOf("TWO")}).build();
    private static final Proto3SchemaMessages.EnumMessage ENUM_PROTO = Proto3SchemaMessages.EnumMessage.newBuilder().setEnum(Proto3SchemaMessages.EnumMessage.Enum.TWO).build();

    private ProtoDynamicMessageSchema schemaFromDescriptor(Descriptors.Descriptor descriptor) {
        ProtoDomain domain = ProtoDomain.buildFrom((Descriptors.Descriptor)descriptor);
        return ProtoDynamicMessageSchema.forDescriptor((ProtoDomain)domain, (Descriptors.Descriptor)descriptor);
    }

    private DynamicMessage toDynamic(Message message) throws InvalidProtocolBufferException {
        return DynamicMessage.parseFrom((Descriptors.Descriptor)message.getDescriptorForType(), (byte[])message.toByteArray());
    }

    private static <T extends Message.Builder> T parseFrom(String str, T builder) {
        String charSequence = str;
        try {
            TextFormat.getParser().merge((CharSequence)charSequence, builder);
        }
        catch (TextFormat.ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return builder;
    }

    @Test
    public void testPrimitiveSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.Primitive.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)TestProtoSchemas.PRIMITIVE_SCHEMA, (Object)schema);
    }

    @Test
    public void testPrimitiveProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.Primitive.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.PRIMITIVE_ROW, (Object)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.PRIMITIVE_PROTO)));
    }

    @Test
    public void testPrimitiveRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.Primitive.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.PRIMITIVE_PROTO.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.PRIMITIVE_ROW)).toString());
    }

    @Test
    public void testRepeatedSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.RepeatPrimitive.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)TestProtoSchemas.REPEATED_SCHEMA, (Object)schema);
    }

    @Test
    public void testRepeatedProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.RepeatPrimitive.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.REPEATED_ROW, (Object)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.REPEATED_PROTO)));
    }

    @Test
    public void testRepeatedRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.RepeatPrimitive.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.REPEATED_PROTO.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.REPEATED_ROW)).toString());
    }

    @Test
    public void testNullRepeatedProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.RepeatPrimitive.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.NULL_REPEATED_ROW, (Object)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.NULL_REPEATED_PROTO)));
    }

    @Test
    public void testNullRepeatedRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.RepeatPrimitive.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.NULL_REPEATED_PROTO.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.NULL_REPEATED_ROW)).toString());
    }

    @Test
    public void testMapSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.MapPrimitive.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)TestProtoSchemas.MAP_PRIMITIVE_SCHEMA, (Object)schema);
    }

    @Test
    public void testMapProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.MapPrimitive.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.MAP_PRIMITIVE_ROW, (Object)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.MAP_PRIMITIVE_PROTO)));
    }

    @Test
    public void testMapRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.MapPrimitive.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Proto3SchemaMessages.MapPrimitive proto = ProtoDynamicMessageSchemaTest.parseFrom(((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.MAP_PRIMITIVE_ROW)).toString(), Proto3SchemaMessages.MapPrimitive.newBuilder()).build();
        Assert.assertEquals((Object)TestProtoSchemas.MAP_PRIMITIVE_PROTO, (Object)proto);
    }

    @Test
    public void testNullMapProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.MapPrimitive.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.NULL_MAP_PRIMITIVE_ROW, (Object)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.NULL_MAP_PRIMITIVE_PROTO)));
    }

    @Test
    public void testNullMapRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.MapPrimitive.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Proto3SchemaMessages.MapPrimitive proto = ProtoDynamicMessageSchemaTest.parseFrom(((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.NULL_MAP_PRIMITIVE_ROW)).toString(), Proto3SchemaMessages.MapPrimitive.newBuilder()).build();
        Assert.assertEquals((Object)TestProtoSchemas.NULL_MAP_PRIMITIVE_PROTO, (Object)proto);
    }

    @Test
    public void testNestedSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.Nested.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)TestProtoSchemas.NESTED_SCHEMA, (Object)schema);
    }

    @Test
    public void testNestedProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.Nested.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.NESTED_ROW, (Object)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.NESTED_PROTO)));
    }

    @Test
    public void testNestedRowToProto() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.Nested.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Proto3SchemaMessages.Nested proto = ProtoDynamicMessageSchemaTest.parseFrom(((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.NESTED_ROW)).toString(), Proto3SchemaMessages.Nested.newBuilder()).build();
        Assert.assertEquals((Object)TestProtoSchemas.NESTED_PROTO, (Object)proto);
    }

    @Test
    public void testOneOfSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.OneOf.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_SCHEMA, (Object)schema);
    }

    @Test
    public void testOneOfProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.OneOf.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_ROW_INT32.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.ONEOF_PROTO_INT32))).toString());
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_ROW_BOOL.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.ONEOF_PROTO_BOOL))).toString());
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_ROW_STRING.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.ONEOF_PROTO_STRING))).toString());
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_ROW_PRIMITIVE.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.ONEOF_PROTO_PRIMITIVE))).toString());
    }

    @Test
    public void testOneOfRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.OneOf.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_PROTO_INT32.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.ONEOF_ROW_INT32)).toString());
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_PROTO_BOOL.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.ONEOF_ROW_BOOL)).toString());
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_PROTO_STRING.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.ONEOF_ROW_STRING)).toString());
        Assert.assertEquals((Object)TestProtoSchemas.ONEOF_PROTO_PRIMITIVE.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.ONEOF_ROW_PRIMITIVE)).toString());
    }

    @Test
    public void testReversedOneOfSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.ReversedOneOf.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_SCHEMA, (Object)schema);
    }

    @Test
    public void testReversedOneOfProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.ReversedOneOf.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_INT32.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.REVERSED_ONEOF_PROTO_INT32))).toString());
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_BOOL.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.REVERSED_ONEOF_PROTO_BOOL))).toString());
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_STRING.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.REVERSED_ONEOF_PROTO_STRING))).toString());
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_PRIMITIVE.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.REVERSED_ONEOF_PROTO_PRIMITIVE))).toString());
    }

    @Test
    public void testReversedOneOfRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.ReversedOneOf.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_INT32.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_INT32)).toString());
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_BOOL.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_BOOL)).toString());
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_STRING.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_STRING)).toString());
        Assert.assertEquals((Object)TestProtoSchemas.REVERSED_ONEOF_PROTO_PRIMITIVE.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.REVERSED_ONEOF_ROW_PRIMITIVE)).toString());
    }

    @Test
    public void testNonContiguousOneOfSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.NonContiguousOneOf.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)TestProtoSchemas.NONCONTIGUOUS_ONEOF_SCHEMA, (Object)schema);
    }

    @Test
    public void testNonContiguousOneOfProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.NonContiguousOneOf.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.NONCONTIGUOUS_ONEOF_ROW.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.NONCONTIGUOUS_ONEOF_PROTO))).toString());
    }

    @Test
    public void testNonContiguousOneOfRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.NonContiguousOneOf.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.NONCONTIGUOUS_ONEOF_PROTO.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.NONCONTIGUOUS_ONEOF_ROW)).toString());
    }

    @Test
    public void testOuterOneOfSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.OuterOneOf.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)TestProtoSchemas.OUTER_ONEOF_SCHEMA, (Object)schema);
    }

    @Test
    public void testOuterOneOfProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.OuterOneOf.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.OUTER_ONEOF_ROW.toString(), (Object)((Row)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.OUTER_ONEOF_PROTO))).toString());
    }

    @Test
    public void testOuterOneOfRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.OuterOneOf.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.OUTER_ONEOF_PROTO.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.OUTER_ONEOF_ROW)).toString());
    }

    @Test
    public void testEnumSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.EnumMessage.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)ENUM_SCHEMA, (Object)schema);
    }

    @Test
    public void testEnumProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.EnumMessage.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)ENUM_ROW, (Object)toRow.apply((Object)this.toDynamic((Message)ENUM_PROTO)));
    }

    @Test
    public void testEnumRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.EnumMessage.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Assert.assertEquals((Object)ENUM_PROTO.toString(), (Object)((DynamicMessage)fromRow.apply((Object)ENUM_ROW)).toString());
    }

    @Test
    public void testWktMessageSchema() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.WktMessage.getDescriptor());
        Schema schema = schemaProvider.getSchema();
        Assert.assertEquals((Object)TestProtoSchemas.WKT_MESSAGE_SCHEMA, (Object)schema);
    }

    @Test
    public void testWktProtoToRow() throws InvalidProtocolBufferException {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.WktMessage.getDescriptor());
        SerializableFunction toRow = schemaProvider.getToRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.WKT_MESSAGE_ROW, (Object)toRow.apply((Object)this.toDynamic((Message)TestProtoSchemas.WKT_MESSAGE_PROTO)));
    }

    @Test
    public void testWktRowToProto() {
        ProtoDynamicMessageSchema schemaProvider = this.schemaFromDescriptor(Proto3SchemaMessages.WktMessage.getDescriptor());
        SerializableFunction fromRow = schemaProvider.getFromRowFunction();
        Assert.assertEquals((Object)TestProtoSchemas.WKT_MESSAGE_PROTO.toString(), (Object)((DynamicMessage)fromRow.apply((Object)TestProtoSchemas.WKT_MESSAGE_ROW)).toString());
    }
}

