/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import org.apache.beam.sdk.extensions.protobuf.Proto3SchemaMessages;
import org.apache.beam.sdk.extensions.protobuf.ProtoDomain;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoDomainTest {
    @Test
    public void testNamespaceEqual() {
        ProtoDomain domainFromInt32 = ProtoDomain.buildFrom((Descriptors.Descriptor)Int32Value.getDescriptor());
        ProtoDomain domainFromInt64 = ProtoDomain.buildFrom((Descriptors.Descriptor)Int64Value.getDescriptor());
        Assert.assertTrue((boolean)domainFromInt64.equals((Object)domainFromInt32));
    }

    @Test
    public void testContainsDescriptor() {
        ProtoDomain domainFromInt32 = ProtoDomain.buildFrom((Descriptors.Descriptor)Proto3SchemaMessages.Primitive.getDescriptor());
        Assert.assertTrue((boolean)domainFromInt32.contains(Proto3SchemaMessages.Primitive.getDescriptor()));
    }

    @Test
    public void testContainsOtherDescriptorSameFile() {
        ProtoDomain domain = ProtoDomain.buildFrom((Descriptors.Descriptor)Proto3SchemaMessages.Primitive.getDescriptor());
        Assert.assertTrue((boolean)domain.contains(Proto3SchemaMessages.Nested.getDescriptor()));
    }

    @Test
    public void testBuildForFile() {
        ProtoDomain domain = ProtoDomain.buildFrom((Descriptors.FileDescriptor)Proto3SchemaMessages.Primitive.getDescriptor().getFile());
        Assert.assertNotNull((Object)domain.getFileDescriptor("google/protobuf/wrappers.proto"));
    }
}

