/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.Message;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.protobuf.Proto2CoderTestMessages;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.extensions.protobuf.ProtobufUtil;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtobufUtilTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> MESSAGE_A_ONLY = ImmutableSet.of((Object)"proto2_coder_test_messages.MessageA");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> MESSAGE_B_ONLY = ImmutableSet.of((Object)"proto2_coder_test_messages.MessageB");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> MESSAGE_C_ONLY = ImmutableSet.of((Object)"proto2_coder_test_messages.MessageC");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> WITH_MAP_ONLY = ImmutableSet.of((Object)"proto2_coder_test_messages.MessageWithMap", (Object)"proto2_coder_test_messages.MessageWithMap.Field1Entry");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> REFERS_MAP_ONLY = ImmutableSet.of((Object)"proto2_coder_test_messages.ReferencesMessageWithMap");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> MESSAGE_A_ALL = Sets.union(MESSAGE_A_ONLY, MESSAGE_B_ONLY);
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> MESSAGE_C_EXT = Sets.union(MESSAGE_C_ONLY, MESSAGE_A_ALL);
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> WITH_MAP_ALL = Sets.union(WITH_MAP_ONLY, MESSAGE_A_ALL);
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> REFERS_MAP_ALL = Sets.union(REFERS_MAP_ONLY, WITH_MAP_ALL);

    @Test
    public void testRecursiveDescriptorsMessageA() {
        MatcherAssert.assertThat(ProtobufUtilTest.getRecursiveDescriptorFullNames(Proto2CoderTestMessages.MessageA.class), (Matcher)Matchers.equalTo(MESSAGE_A_ALL));
    }

    @Test
    public void testRecursiveDescriptorsMessageB() {
        MatcherAssert.assertThat(ProtobufUtilTest.getRecursiveDescriptorFullNames(Proto2CoderTestMessages.MessageB.class), (Matcher)Matchers.equalTo(MESSAGE_B_ONLY));
    }

    @Test
    public void testRecursiveDescriptorsMessageC() {
        MatcherAssert.assertThat(ProtobufUtilTest.getRecursiveDescriptorFullNames(Proto2CoderTestMessages.MessageC.class), (Matcher)Matchers.equalTo(MESSAGE_C_ONLY));
    }

    @Test
    public void testRecursiveDescriptorsMessageCWithExtensions() {
        ExtensionRegistry registry = ExtensionRegistry.newInstance();
        Proto2CoderTestMessages.registerAllExtensions(registry);
        MatcherAssert.assertThat(ProtobufUtilTest.getRecursiveDescriptorFullNames(Proto2CoderTestMessages.MessageC.class, registry), (Matcher)Matchers.equalTo(MESSAGE_C_EXT));
    }

    @Test
    public void testRecursiveDescriptorsMessageWithMap() {
        MatcherAssert.assertThat(ProtobufUtilTest.getRecursiveDescriptorFullNames(Proto2CoderTestMessages.MessageWithMap.class), (Matcher)Matchers.equalTo(WITH_MAP_ALL));
    }

    @Test
    public void testRecursiveDescriptorsReferencesMessageWithMap() {
        MatcherAssert.assertThat(ProtobufUtilTest.getRecursiveDescriptorFullNames(Proto2CoderTestMessages.ReferencesMessageWithMap.class), (Matcher)Matchers.equalTo(REFERS_MAP_ALL));
    }

    @Test
    public void testVerifyProto2() {
        ProtobufUtil.checkProto2Syntax(Proto2CoderTestMessages.MessageA.class, (ExtensionRegistry)ExtensionRegistry.getEmptyRegistry());
        ProtobufUtil.checkProto2Syntax(Proto2CoderTestMessages.MessageB.class, (ExtensionRegistry)ExtensionRegistry.getEmptyRegistry());
        ProtobufUtil.checkProto2Syntax(Proto2CoderTestMessages.MessageC.class, (ExtensionRegistry)ExtensionRegistry.getEmptyRegistry());
        ProtobufUtil.checkProto2Syntax(Proto2CoderTestMessages.MessageWithMap.class, (ExtensionRegistry)ExtensionRegistry.getEmptyRegistry());
        ProtobufUtil.checkProto2Syntax(Proto2CoderTestMessages.ReferencesMessageWithMap.class, (ExtensionRegistry)ExtensionRegistry.getEmptyRegistry());
    }

    @Test
    public void testAnyIsNotProto2() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(Any.class.getCanonicalName());
        this.thrown.expectMessage("in file " + Any.getDescriptor().getFile().getName());
        ProtobufUtil.checkProto2Syntax(Any.class, (ExtensionRegistry)ExtensionRegistry.getEmptyRegistry());
    }

    @Test
    public void testDurationIsNotProto2() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(Duration.class.getCanonicalName());
        this.thrown.expectMessage("in file " + Duration.getDescriptor().getFile().getName());
        ProtobufUtil.checkProto2Syntax(Duration.class, (ExtensionRegistry)ExtensionRegistry.getEmptyRegistry());
    }

    @Test
    public void testDurationIsDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        ProtobufUtil.verifyDeterministic((ProtoCoder)ProtoCoder.of(Duration.class));
    }

    @Test
    public void testMessageWithMapIsNotDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        String mapFieldName = Proto2CoderTestMessages.MessageWithMap.getDescriptor().findFieldByNumber(1).getFullName();
        this.thrown.expect(Coder.NonDeterministicException.class);
        this.thrown.expectMessage(Proto2CoderTestMessages.MessageWithMap.class.getName());
        this.thrown.expectMessage("transitively includes Map field " + mapFieldName);
        this.thrown.expectMessage("file " + Proto2CoderTestMessages.MessageWithMap.getDescriptor().getFile().getName());
        ProtobufUtil.verifyDeterministic((ProtoCoder)ProtoCoder.of(Proto2CoderTestMessages.MessageWithMap.class));
    }

    @Test
    public void testMessageWithTransitiveMapIsNotDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        String mapFieldName = Proto2CoderTestMessages.MessageWithMap.getDescriptor().findFieldByNumber(1).getFullName();
        this.thrown.expect(Coder.NonDeterministicException.class);
        this.thrown.expectMessage(Proto2CoderTestMessages.ReferencesMessageWithMap.class.getName());
        this.thrown.expectMessage("transitively includes Map field " + mapFieldName);
        this.thrown.expectMessage("file " + Proto2CoderTestMessages.MessageWithMap.getDescriptor().getFile().getName());
        ProtobufUtil.verifyDeterministic((ProtoCoder)ProtoCoder.of(Proto2CoderTestMessages.ReferencesMessageWithMap.class));
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getRecursiveDescriptorFullNames(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Message> clazz) {
        return ProtobufUtilTest.getRecursiveDescriptorFullNames(clazz, ExtensionRegistry.getEmptyRegistry());
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getRecursiveDescriptorFullNames(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Message> clazz, @UnknownKeyFor @NonNull @Initialized ExtensionRegistry registry) {
        HashSet<String> result = new HashSet<String>();
        for (Descriptors.GenericDescriptor d : ProtobufUtil.getRecursiveDescriptorsForClass(clazz, (ExtensionRegistry)registry)) {
            result.add(d.getFullName());
        }
        return result;
    }
}

