/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.GeneratedMessage;
import java.io.ObjectStreamClass;
import java.util.Collections;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.extensions.protobuf.Proto2CoderTestMessages;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoCoderTest {
    @Rule
    public @UnknownKeyFor @NonNull @Initialized ExpectedException thrown = ExpectedException.none();

    @Test
    public void testFactoryMethodAgreement() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Assert.assertEquals((Object)ProtoCoder.of((TypeDescriptor)new TypeDescriptor<Proto2CoderTestMessages.MessageA>(){}), (Object)ProtoCoder.of(Proto2CoderTestMessages.MessageA.class));
        Assert.assertEquals((Object)ProtoCoder.of((TypeDescriptor)new TypeDescriptor<Proto2CoderTestMessages.MessageA>(){}), (Object)ProtoCoder.getCoderProvider().coderFor((TypeDescriptor)new TypeDescriptor<Proto2CoderTestMessages.MessageA>(){}, Collections.emptyList()));
    }

    @Test
    public void testProviderCannotProvideCoder() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.thrown.expect(CannotProvideCoderException.class);
        this.thrown.expectMessage("java.lang.Integer is not a subclass of com.google.protobuf.Message");
        ProtoCoder.getCoderProvider().coderFor((TypeDescriptor)new TypeDescriptor<Integer>(){}, Collections.emptyList());
    }

    @Test
    public void testCoderEncodeDecodeEqual() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Proto2CoderTestMessages.MessageA value = Proto2CoderTestMessages.MessageA.newBuilder().setField1("hello").addField2(Proto2CoderTestMessages.MessageB.newBuilder().setField1(true).build()).addField2(Proto2CoderTestMessages.MessageB.newBuilder().setField1(false).build()).build();
        CoderProperties.coderDecodeEncodeEqual((Coder)ProtoCoder.of(Proto2CoderTestMessages.MessageA.class), (Object)value);
    }

    @Test
    public void testCoderEncodeDecodeEqualNestedContext() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Proto2CoderTestMessages.MessageA value1 = Proto2CoderTestMessages.MessageA.newBuilder().setField1("hello").addField2(Proto2CoderTestMessages.MessageB.newBuilder().setField1(true).build()).addField2(Proto2CoderTestMessages.MessageB.newBuilder().setField1(false).build()).build();
        Proto2CoderTestMessages.MessageA value2 = Proto2CoderTestMessages.MessageA.newBuilder().setField1("world").addField2(Proto2CoderTestMessages.MessageB.newBuilder().setField1(false).build()).addField2(Proto2CoderTestMessages.MessageB.newBuilder().setField1(true).build()).build();
        CoderProperties.coderDecodeEncodeEqual((Coder)ListCoder.of((Coder)ProtoCoder.of(Proto2CoderTestMessages.MessageA.class)), (Object)ImmutableList.of((Object)value1, (Object)value2));
    }

    @Test
    public void testCoderEncodeDecodeExtensionsEqual() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Proto2CoderTestMessages.MessageC value = Proto2CoderTestMessages.MessageC.newBuilder().setExtension((GeneratedMessage.GeneratedExtension)Proto2CoderTestMessages.field1, Proto2CoderTestMessages.MessageA.newBuilder().setField1("hello").addField2(Proto2CoderTestMessages.MessageB.newBuilder().setField1(true).build()).build()).setExtension((GeneratedMessage.GeneratedExtension)Proto2CoderTestMessages.field2, Proto2CoderTestMessages.MessageB.newBuilder().setField1(false).build()).build();
        CoderProperties.coderDecodeEncodeEqual((Coder)ProtoCoder.of(Proto2CoderTestMessages.MessageC.class).withExtensionsFrom(new Class[]{Proto2CoderTestMessages.class}), (Object)value);
    }

    @Test
    public void testCoderSerialization() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ProtoCoder coder = ProtoCoder.of(Proto2CoderTestMessages.MessageA.class);
        CoderProperties.coderSerializable((Coder)coder);
    }

    @Test
    public void testCoderExtensionsSerialization() throws @UnknownKeyFor @NonNull @Initialized Exception {
        ProtoCoder coder = ProtoCoder.of(Proto2CoderTestMessages.MessageC.class).withExtensionsFrom(new Class[]{Proto2CoderTestMessages.class});
        CoderProperties.coderSerializable((Coder)coder);
    }

    @Test
    public void encodeNullThrowsCoderException() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.thrown.expect(CoderException.class);
        this.thrown.expectMessage("cannot encode a null MessageA");
        CoderUtils.encodeToBase64((Coder)ProtoCoder.of(Proto2CoderTestMessages.MessageA.class), null);
    }

    @Test
    public void testDeterministicCoder() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        ProtoCoder coder = ProtoCoder.of(Proto2CoderTestMessages.MessageA.class);
        coder.verifyDeterministic();
    }

    @Test
    public void testNonDeterministicCoder() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.thrown.expect(Coder.NonDeterministicException.class);
        this.thrown.expectMessage(Proto2CoderTestMessages.MessageWithMap.class.getName() + " transitively includes Map field");
        ProtoCoder coder = ProtoCoder.of(Proto2CoderTestMessages.MessageWithMap.class);
        coder.verifyDeterministic();
    }

    @Test
    public void testNonDeterministicProperty() throws @UnknownKeyFor @NonNull @Initialized CoderException {
        Proto2CoderTestMessages.MessageWithMap.Builder msg1B = Proto2CoderTestMessages.MessageWithMap.newBuilder();
        Proto2CoderTestMessages.MessageWithMap.Builder msg2B = Proto2CoderTestMessages.MessageWithMap.newBuilder();
        for (int i = 0; i < 10; ++i) {
            msg1B.getMutableField1().put("key" + i, Proto2CoderTestMessages.MessageA.getDefaultInstance());
            msg2B.getMutableField1().put("key" + (9 - i), Proto2CoderTestMessages.MessageA.getDefaultInstance());
        }
        Proto2CoderTestMessages.MessageWithMap msg1 = msg1B.build();
        Proto2CoderTestMessages.MessageWithMap msg2 = msg2B.build();
        Assert.assertEquals((Object)msg2, (Object)msg1);
        ProtoCoder coder = ProtoCoder.of(Proto2CoderTestMessages.MessageWithMap.class);
        Assert.assertNotEquals((Object)CoderUtils.encodeToBase64((Coder)coder, (Object)msg2), (Object)CoderUtils.encodeToBase64((Coder)coder, (Object)msg1));
    }

    @Test
    public void testSerialVersionID() {
        long serialVersionID = ObjectStreamClass.lookup(ProtoCoder.class).getSerialVersionUID();
        Assert.assertEquals((long)-5043999806040629525L, (long)serialVersionID);
    }
}

