/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.videointelligence.v1.Feature;
import com.google.cloud.videointelligence.v1.LabelDetectionConfig;
import com.google.cloud.videointelligence.v1.VideoAnnotationResults;
import com.google.cloud.videointelligence.v1.VideoContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.beam.sdk.extensions.ml.VideoIntelligence;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class VideoIntelligenceIT {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();
    private static final String VIDEO_URI = "gs://apache-beam-samples/advanced_analytics/video/gbikes_dinosaur.mp4";
    private List<Feature> featureList = Collections.singletonList(Feature.LABEL_DETECTION);

    @Test
    public void annotateVideoFromURIWithContext() {
        VideoContext context = VideoContext.newBuilder().setLabelDetectionConfig(LabelDetectionConfig.newBuilder().setModel("builtin/latest")).build();
        PCollection annotationResults = (PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)KV.of((Object)VIDEO_URI, (Object)context), (Object[])new KV[0]))).apply("Annotate video", (PTransform)VideoIntelligence.annotateFromUriWithContext(this.featureList));
        PAssert.that((PCollection)annotationResults).satisfies((SerializableFunction)new VerifyVideoAnnotationResult());
        this.testPipeline.run().waitUntilFinish();
    }

    private static class VerifyVideoAnnotationResult
    implements SerializableFunction<Iterable<List<VideoAnnotationResults>>, Void> {
        private VerifyVideoAnnotationResult() {
        }

        public Void apply(Iterable<List<VideoAnnotationResults>> input) {
            ArrayList<Boolean> labelEvaluations = new ArrayList<Boolean>();
            input.forEach(this.findStringMatchesInVideoAnnotationResultList(labelEvaluations, "bicycle"));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)labelEvaluations.contains(Boolean.TRUE));
            return null;
        }

        private Consumer<List<VideoAnnotationResults>> findStringMatchesInVideoAnnotationResultList(List<Boolean> labelEvaluations, String toMatch) {
            return videoAnnotationResults -> labelEvaluations.add(videoAnnotationResults.stream().anyMatch(result -> this.entityWithDescriptionFoundInSegmentLabels(toMatch, (VideoAnnotationResults)result)));
        }

        private boolean entityWithDescriptionFoundInSegmentLabels(String toMatch, VideoAnnotationResults result) {
            return result.getSegmentPresenceLabelAnnotationsList().stream().anyMatch(labelAnnotation -> labelAnnotation.getEntity().getDescription().contains(toMatch));
        }
    }
}

