/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.client.json.GenericJson;
import com.google.cloud.recommendationengine.v1beta1.UserEvent;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.ml.GenericJsonCoder;
import org.apache.beam.sdk.extensions.ml.RecommendationAIIO;
import org.apache.beam.sdk.extensions.ml.RecommendationAIImportUserEvents;
import org.apache.beam.sdk.extensions.ml.RecommendationAIWriteUserEvent;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RecommendationAIUserEventIT {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();

    public static GenericJson getUserEvent() {
        GenericJson userInfo = new GenericJson().set("visitorId", (Object)"1");
        GenericJson productDetail = new GenericJson().set("id", (Object)"1").set("quantity", (Object)1);
        ArrayList<GenericJson> productDetails = new ArrayList<GenericJson>();
        productDetails.add(productDetail);
        GenericJson productEventDetail = new GenericJson().set("productDetails", productDetails);
        return new GenericJson().set("eventType", (Object)"detail-page-view").set("userInfo", (Object)userInfo).set("productEventDetail", (Object)productEventDetail);
    }

    @Test
    public void createUserEvent() {
        String projectId = ((GcpOptions)this.testPipeline.getOptions().as(GcpOptions.class)).getProject();
        PCollectionTuple createUserEventResult = (PCollectionTuple)((PCollection)this.testPipeline.apply((PTransform)Create.of(Arrays.asList(RecommendationAIUserEventIT.getUserEvent())).withCoder(GenericJsonCoder.of(GenericJson.class)))).apply((PTransform)RecommendationAIIO.writeUserEvent().withProjectId(projectId));
        PAssert.that((PCollection)createUserEventResult.get(RecommendationAIWriteUserEvent.SUCCESS_TAG)).satisfies((SerializableFunction)new VerifyUserEventResult(1));
        this.testPipeline.run().waitUntilFinish();
    }

    @Ignore(value="Import method causing issues")
    @Test
    public void importUserEvents() {
        String projectId = ((GcpOptions)this.testPipeline.getOptions().as(GcpOptions.class)).getProject();
        ArrayList<KV> userEvents = new ArrayList<KV>();
        userEvents.add(KV.of((Object)"123", (Object)RecommendationAIUserEventIT.getUserEvent()));
        userEvents.add(KV.of((Object)"123", (Object)RecommendationAIUserEventIT.getUserEvent()));
        PCollectionTuple importUserEventResult = (PCollectionTuple)((PCollection)this.testPipeline.apply((PTransform)Create.of(userEvents))).apply((PTransform)RecommendationAIImportUserEvents.newBuilder().setProjectId(projectId).build());
        PAssert.that((PCollection)importUserEventResult.get(RecommendationAIWriteUserEvent.SUCCESS_TAG)).satisfies((SerializableFunction)new VerifyUserEventResult(2));
        this.testPipeline.run().waitUntilFinish();
    }

    private static class VerifyUserEventResult
    implements SerializableFunction<Iterable<UserEvent>, Void> {
        int size;

        private VerifyUserEventResult(int size) {
            this.size = size;
        }

        public Void apply(Iterable<UserEvent> input) {
            ArrayList matches = new ArrayList();
            input.forEach(item -> {
                UserEvent result = item;
                matches.add(result.getUserInfo().getVisitorId());
            });
            Assert.assertTrue((boolean)matches.contains(((GenericJson)RecommendationAIUserEventIT.getUserEvent().get((Object)"userInfo")).get((Object)"visitorId")));
            Assert.assertEquals((long)this.size, (long)matches.size());
            return null;
        }
    }
}

