/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.client.json.GenericJson;
import com.google.cloud.recommendationengine.v1beta1.PredictResponse;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.ml.GenericJsonCoder;
import org.apache.beam.sdk.extensions.ml.RecommendationAIIO;
import org.apache.beam.sdk.extensions.ml.RecommendationAIPredict;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RecommendationAIPredictIT {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();

    public static GenericJson getUserEvent() {
        GenericJson userInfo = new GenericJson().set("visitorId", (Object)"1");
        return new GenericJson().set("eventType", (Object)"home-page-view").set("userInfo", (Object)userInfo);
    }

    @Ignore(value="https://issues.apache.org/jira/browse/BEAM-12733")
    @Test
    public void predict() {
        String projectId = ((GcpOptions)this.testPipeline.getOptions().as(GcpOptions.class)).getProject();
        PCollectionTuple predictResult = (PCollectionTuple)((PCollection)this.testPipeline.apply((PTransform)Create.of(Arrays.asList(RecommendationAIPredictIT.getUserEvent())).withCoder(GenericJsonCoder.of(GenericJson.class)))).apply((PTransform)RecommendationAIIO.predictAll().withProjectId(projectId).withPlacementId("recently_viewed_default"));
        PAssert.that((PCollection)predictResult.get(RecommendationAIPredict.SUCCESS_TAG)).satisfies((SerializableFunction)new VerifyPredictResult());
        this.testPipeline.run().waitUntilFinish();
    }

    private static class VerifyPredictResult
    implements SerializableFunction<Iterable<PredictResponse.PredictionResult>, Void> {
        private VerifyPredictResult() {
        }

        public Void apply(Iterable<PredictResponse.PredictionResult> input) {
            ArrayList matches = new ArrayList();
            input.forEach(item -> {
                PredictResponse.PredictionResult result = item;
                matches.add(result);
            });
            Assert.assertTrue((!matches.isEmpty() ? 1 : 0) != 0);
            return null;
        }
    }
}

