/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.client.json.GenericJson;
import com.google.cloud.recommendationengine.v1beta1.CatalogItem;
import com.google.cloud.recommendationengine.v1beta1.CatalogName;
import com.google.cloud.recommendationengine.v1beta1.CatalogServiceClient;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.ml.GenericJsonCoder;
import org.apache.beam.sdk.extensions.ml.RecommendationAICreateCatalogItem;
import org.apache.beam.sdk.extensions.ml.RecommendationAIIO;
import org.apache.beam.sdk.extensions.ml.RecommendationAIImportCatalogItems;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RecommendationAICatalogItemIT {
    @ClassRule
    public static TestPipeline testPipeline = TestPipeline.create();
    private static String projectId = ((GcpOptions)testPipeline.getOptions().as(GcpOptions.class)).getProject();
    private static final String randomId = "aitest-" + Instant.now().getEpochSecond() + UUID.randomUUID().toString();

    private GenericJson getCatalogItem() {
        ArrayList<GenericJson> categories = new ArrayList<GenericJson>();
        categories.add(new GenericJson().set("categories", Arrays.asList("Electronics", "Computers")));
        categories.add(new GenericJson().set("categories", Arrays.asList("Laptops")));
        return new GenericJson().set("id", (Object)randomId).set("title", (Object)"Sample Laptop").set("description", (Object)"Indisputably the most fantastic laptop ever created.").set("categoryHierarchies", categories).set("languageCode", (Object)"en");
    }

    @Test
    public void createCatalogItem() {
        GenericJson catalogItem = this.getCatalogItem();
        PCollectionTuple createCatalogItemResult = (PCollectionTuple)((PCollection)testPipeline.apply((PTransform)Create.of(Arrays.asList(catalogItem)).withCoder(GenericJsonCoder.of(GenericJson.class)))).apply((PTransform)RecommendationAIIO.createCatalogItems().withProjectId(projectId));
        PAssert.that((PCollection)createCatalogItemResult.get(RecommendationAICreateCatalogItem.SUCCESS_TAG)).satisfies((SerializableFunction)new VerifyCatalogItemResult(1, (String)catalogItem.get((Object)"id")));
        testPipeline.run().waitUntilFinish();
    }

    @Ignore(value="Import method causing issues")
    @Test
    public void importCatalogItems() {
        ArrayList<KV> catalogItems = new ArrayList<KV>();
        GenericJson catalogItem1 = this.getCatalogItem();
        GenericJson catalogItem2 = this.getCatalogItem();
        catalogItems.add(KV.of((Object)Integer.toString(new Random().nextInt()), (Object)catalogItem1));
        catalogItems.add(KV.of((Object)Integer.toString(new Random().nextInt()), (Object)catalogItem2));
        PCollectionTuple importCatalogItemResult = (PCollectionTuple)((PCollection)testPipeline.apply((PTransform)Create.of(catalogItems))).apply((PTransform)RecommendationAIImportCatalogItems.newBuilder().setProjectId(projectId).build());
        PAssert.that((PCollection)importCatalogItemResult.get(RecommendationAIImportCatalogItems.SUCCESS_TAG)).satisfies((SerializableFunction)new VerifyCatalogItemResult(2, (String)catalogItem1.get((Object)"id")));
        testPipeline.run().waitUntilFinish();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        try (CatalogServiceClient catalogServiceClient = CatalogServiceClient.create();){
            String parent = CatalogName.of((String)projectId, (String)"global", (String)"default_catalog").toString();
            String filter = "";
            for (CatalogItem item : catalogServiceClient.listCatalogItems(parent, filter).iterateAll()) {
                StringBuilder toDelete = new StringBuilder();
                toDelete.append("projects/");
                toDelete.append(projectId);
                toDelete.append("/locations/global/catalogs/default_catalog/catalogItems/");
                toDelete.append(item.getId());
                catalogServiceClient.deleteCatalogItem(toDelete.toString());
            }
        }
    }

    private static class VerifyCatalogItemResult
    implements SerializableFunction<Iterable<CatalogItem>, Void> {
        String catalogItemId;
        int size;

        private VerifyCatalogItemResult(int size, String catalogItemId) {
            this.size = size;
            this.catalogItemId = catalogItemId;
        }

        public Void apply(Iterable<CatalogItem> input) {
            ArrayList matches = new ArrayList();
            input.forEach(item -> {
                CatalogItem result = item;
                matches.add(result.getId());
            });
            Assert.assertTrue((boolean)matches.contains(this.catalogItemId));
            Assert.assertEquals((long)this.size, (long)matches.size());
            return null;
        }
    }
}

