/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.privacy.dlp.v2.CharacterMaskConfig;
import com.google.privacy.dlp.v2.DeidentifyConfig;
import com.google.privacy.dlp.v2.DeidentifyContentResponse;
import com.google.privacy.dlp.v2.FieldId;
import com.google.privacy.dlp.v2.InfoType;
import com.google.privacy.dlp.v2.InfoTypeTransformations;
import com.google.privacy.dlp.v2.InspectConfig;
import com.google.privacy.dlp.v2.InspectContentResponse;
import com.google.privacy.dlp.v2.Likelihood;
import com.google.privacy.dlp.v2.PrimitiveTransformation;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.extensions.ml.DLPDeidentifyText;
import org.apache.beam.sdk.extensions.ml.DLPInspectText;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DLPTextOperationsIT {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();
    private static final String IDENTIFYING_TEXT = "mary.sue@example.com";
    private static InfoType emailAddress = InfoType.newBuilder().setName("EMAIL_ADDRESS").build();
    private static final InspectConfig inspectConfig = InspectConfig.newBuilder().addInfoTypes(emailAddress).setMinLikelihood(Likelihood.LIKELY).build();

    @Test
    public void inspectsText() {
        String projectId = ((GcpOptions)this.testPipeline.getOptions().as(GcpOptions.class)).getProject();
        PCollection inspectionResult = (PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)KV.of((Object)"", (Object)IDENTIFYING_TEXT), (Object[])new KV[0]))).apply((PTransform)DLPInspectText.newBuilder().setBatchSizeBytes(Integer.valueOf(524000)).setProjectId(projectId).setInspectConfig(inspectConfig).build());
        PAssert.that((PCollection)inspectionResult).satisfies((SerializableFunction)new VerifyInspectionResult());
        this.testPipeline.run().waitUntilFinish();
    }

    @Test
    public void deidentifiesText() {
        String projectId = ((GcpOptions)this.testPipeline.getOptions().as(GcpOptions.class)).getProject();
        PCollection deidentificationResult = (PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)KV.of((Object)"", (Object)IDENTIFYING_TEXT), (Object[])new KV[0]))).apply((PTransform)DLPDeidentifyText.newBuilder().setBatchSizeBytes(Integer.valueOf(524000)).setProjectId(projectId).setDeidentifyConfig(this.getDeidentifyConfig()).build());
        PAssert.that((PCollection)deidentificationResult).satisfies((SerializableFunction)new VerifyDeidentificationResult("####################"));
        this.testPipeline.run().waitUntilFinish();
    }

    private DeidentifyConfig getDeidentifyConfig() {
        CharacterMaskConfig characterMaskConfig = CharacterMaskConfig.newBuilder().setMaskingCharacter("#").build();
        PrimitiveTransformation primitiveTransformation = PrimitiveTransformation.newBuilder().setCharacterMaskConfig(characterMaskConfig).build();
        InfoTypeTransformations.InfoTypeTransformation infoTypeTransformation = InfoTypeTransformations.InfoTypeTransformation.newBuilder().addInfoTypes(emailAddress).setPrimitiveTransformation(primitiveTransformation).build();
        return DeidentifyConfig.newBuilder().setInfoTypeTransformations(InfoTypeTransformations.newBuilder().addTransformations(infoTypeTransformation).build()).build();
    }

    private static class VerifyDeidentificationResult
    implements SerializableFunction<Iterable<KV<String, DeidentifyContentResponse>>, Void> {
        private final String expectedValue;

        public VerifyDeidentificationResult(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        public Void apply(Iterable<KV<String, DeidentifyContentResponse>> input) {
            ArrayList matches = new ArrayList();
            input.forEach(item -> {
                ((DeidentifyContentResponse)item.getValue()).getItem().getTable().getRowsList().forEach(row -> matches.add(row.getValuesList().stream().anyMatch(value -> value.getStringValue().equals(this.expectedValue))));
                Assert.assertTrue((boolean)((DeidentifyContentResponse)item.getValue()).getItem().getTable().getHeadersList().contains(FieldId.newBuilder().setName("value").build()));
            });
            Assert.assertTrue((boolean)matches.contains(Boolean.TRUE));
            return null;
        }
    }

    private static class VerifyInspectionResult
    implements SerializableFunction<Iterable<KV<String, InspectContentResponse>>, Void> {
        private VerifyInspectionResult() {
        }

        public Void apply(Iterable<KV<String, InspectContentResponse>> input) {
            ArrayList matches = new ArrayList();
            input.forEach(item -> {
                List resultList = ((InspectContentResponse)item.getValue()).getResult().getFindingsList();
                matches.add(resultList.stream().anyMatch(finding -> finding.getInfoType().equals((Object)emailAddress)));
            });
            Assert.assertTrue((boolean)matches.contains(Boolean.TRUE));
            return null;
        }
    }
}

