/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import org.apache.beam.sdk.extensions.ml.DLPInspectText;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DLPInspectTextTest {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();
    private static final Integer BATCH_SIZE_SMALL = 200;
    private static final String DELIMITER = ";";
    private static final String TEMPLATE_NAME = "test_template";
    private static final String PROJECT_ID = "test_id";

    @Test
    public void throwsExceptionWhenDeidentifyConfigAndTemplatesAreEmpty() {
        Assert.assertThrows((String)"Either inspectTemplateName or inspectConfig must be supplied!", IllegalArgumentException.class, () -> DLPInspectText.newBuilder().setProjectId(PROJECT_ID).setBatchSizeBytes(BATCH_SIZE_SMALL).setColumnDelimiter(DELIMITER).build());
    }

    @Test
    public void throwsExceptionWhenDelimiterIsNullAndHeadersAreSet() {
        PCollectionView header = (PCollectionView)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)"header", (Object[])new String[0]))).apply((PTransform)View.asList());
        Assert.assertThrows((String)"Column delimiter should be set if headers are present.", IllegalArgumentException.class, () -> DLPInspectText.newBuilder().setProjectId(PROJECT_ID).setBatchSizeBytes(BATCH_SIZE_SMALL).setInspectTemplateName(TEMPLATE_NAME).setHeaderColumns(header).build());
        this.testPipeline.run().waitUntilFinish();
    }

    @Test
    public void throwsExceptionWhenBatchSizeIsTooLarge() {
        Assert.assertThrows((String)String.format("Batch size is too large! It should be smaller or equal than %d.", DLPInspectText.DLP_PAYLOAD_LIMIT_BYTES), IllegalArgumentException.class, () -> DLPInspectText.newBuilder().setProjectId(PROJECT_ID).setBatchSizeBytes(Integer.valueOf(Integer.MAX_VALUE)).setInspectTemplateName(TEMPLATE_NAME).setColumnDelimiter(DELIMITER).build());
    }

    @Test
    public void throwsExceptionWhenDelimiterIsSetAndHeadersAreNot() {
        Assert.assertThrows((String)"Column headers should be supplied when delimiter is present.", IllegalArgumentException.class, () -> DLPInspectText.newBuilder().setProjectId(PROJECT_ID).setBatchSizeBytes(BATCH_SIZE_SMALL).setInspectTemplateName(TEMPLATE_NAME).setColumnDelimiter(DELIMITER).build());
    }
}

