/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.vision.v1.AnnotateImageRequest;
import com.google.cloud.vision.v1.Feature;
import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.ml.CloudVision;
import org.apache.beam.sdk.values.KV;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudVisionTest {
    private static final String TEST_URI = "test_uri";
    private static final ByteString TEST_BYTES = ByteString.copyFromUtf8((String)"12345");
    private List<Feature> features = Collections.singletonList(Feature.newBuilder().setType(Feature.Type.LABEL_DETECTION).build());

    @Test
    public void shouldConvertStringToRequest() {
        CloudVision.AnnotateImagesFromGcsUri annotateImagesFromGcsUri = CloudVision.annotateImagesFromGcsUri(null, this.features, (long)1L, (int)1);
        AnnotateImageRequest request = annotateImagesFromGcsUri.mapToRequest(TEST_URI, null);
        Assert.assertEquals((long)1L, (long)request.getFeaturesCount());
        Assert.assertEquals((Object)TEST_URI, (Object)request.getImage().getSource().getGcsImageUri());
    }

    @Test
    public void shouldConvertByteStringToRequest() {
        CloudVision.AnnotateImagesFromBytes annotateImagesFromBytes = CloudVision.annotateImagesFromBytes(null, this.features, (long)1L, (int)1);
        AnnotateImageRequest request = annotateImagesFromBytes.mapToRequest(TEST_BYTES, null);
        Assert.assertEquals((long)1L, (long)request.getFeaturesCount());
        Assert.assertEquals((Object)TEST_BYTES, (Object)request.getImage().getContent());
    }

    @Test
    public void shouldConvertKVOfStringToRequest() {
        CloudVision.AnnotateImagesFromGcsUriWithContext annotateImagesFromGcsUriWithContext = CloudVision.annotateImagesFromGcsUriWithContext(this.features, (long)1L, (int)1);
        AnnotateImageRequest request = annotateImagesFromGcsUriWithContext.mapToRequest(KV.of((Object)TEST_URI, null), null);
        Assert.assertEquals((long)1L, (long)request.getFeaturesCount());
        Assert.assertEquals((Object)TEST_URI, (Object)request.getImage().getSource().getGcsImageUri());
    }

    @Test
    public void shouldConvertKVOfBytesToRequest() {
        CloudVision.AnnotateImagesFromBytesWithContext annotateImagesFromBytesWithContext = CloudVision.annotateImagesFromBytesWithContext(this.features, (long)1L, (int)1);
        AnnotateImageRequest request = annotateImagesFromBytesWithContext.mapToRequest(KV.of((Object)TEST_BYTES, null), null);
        Assert.assertEquals((long)1L, (long)request.getFeaturesCount());
        Assert.assertEquals((Object)TEST_BYTES, (Object)request.getImage().getContent());
    }
}

