/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.vision.v1.AnnotateImageResponse;
import com.google.cloud.vision.v1.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.beam.sdk.extensions.ml.CloudVision;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudVisionIT {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();
    private static final String TEST_IMAGE_URI = "gs://cloud-samples-data/vision/label/setagaya.jpeg";
    private static final String EXPECTED_LABEL = "Street";
    private List<Feature> features = Collections.singletonList(Feature.newBuilder().setType(Feature.Type.LABEL_DETECTION).build());
    private static final int NUMBER_OF_KEYS = 1;

    @Test
    public void annotateImageFromURINoContext() {
        PCollection annotationResponses = (PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)TEST_IMAGE_URI, (Object[])new String[0]))).apply((PTransform)CloudVision.annotateImagesFromGcsUri(null, this.features, (long)1L, (int)1));
        PAssert.that((PCollection)annotationResponses).satisfies((SerializableFunction)new VerifyImageAnnotationResult());
        this.testPipeline.run().waitUntilFinish();
    }

    private static class VerifyImageAnnotationResult
    implements SerializableFunction<Iterable<List<AnnotateImageResponse>>, Void> {
        private VerifyImageAnnotationResult() {
        }

        public Void apply(Iterable<List<AnnotateImageResponse>> input) {
            ArrayList<Boolean> labelMatches = new ArrayList<Boolean>();
            input.forEach(this.findStringMatchesInAnnotationResponse(labelMatches, CloudVisionIT.EXPECTED_LABEL));
            return null;
        }

        private Consumer<? super List<AnnotateImageResponse>> findStringMatchesInAnnotationResponse(List<Boolean> labelMatches, String expectedLabel) {
            return annotateImageResponses -> labelMatches.add(annotateImageResponses.stream().anyMatch(result -> this.entityWithDescriptionFoundInResult(expectedLabel, (AnnotateImageResponse)result)));
        }

        private boolean entityWithDescriptionFoundInResult(String expectedLabel, AnnotateImageResponse result) {
            return result.getLabelAnnotationsList().stream().anyMatch(labelAnnotation -> labelAnnotation.getDescription().equals(expectedLabel));
        }
    }
}

