/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.privacy.dlp.v2.Table;
import java.util.ArrayList;
import org.apache.beam.sdk.extensions.ml.BatchRequestForDLP;
import org.apache.beam.sdk.extensions.ml.MapStringToDlpRow;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BatchRequestForDlpTest {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();

    @Test
    public void batchesRequests() {
        PCollection batchedRows = (PCollection)((PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)KV.of((Object)"key", (Object)"value1"), (Object[])new KV[]{KV.of((Object)"key", (Object)"value2")}))).apply((PTransform)ParDo.of((DoFn)new MapStringToDlpRow(null)))).apply((PTransform)ParDo.of((DoFn)new BatchRequestForDLP(Integer.valueOf(524000))));
        PAssert.that((PCollection)batchedRows).satisfies((SerializableFunction)new VerifyPCollectionSize());
        this.testPipeline.run().waitUntilFinish();
    }

    private static class VerifyPCollectionSize
    implements SerializableFunction<Iterable<KV<String, Iterable<Table.Row>>>, Void> {
        private VerifyPCollectionSize() {
        }

        public Void apply(Iterable<KV<String, Iterable<Table.Row>>> input) {
            ArrayList itemList = new ArrayList();
            input.forEach(itemList::add);
            Assert.assertEquals((long)1L, (long)itemList.size());
            return null;
        }
    }
}

