/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.videointelligence.v1.AnnotateVideoProgress;
import com.google.cloud.videointelligence.v1.AnnotateVideoRequest;
import com.google.cloud.videointelligence.v1.AnnotateVideoResponse;
import com.google.cloud.videointelligence.v1.Feature;
import com.google.cloud.videointelligence.v1.VideoAnnotationResults;
import com.google.cloud.videointelligence.v1.VideoIntelligenceServiceClient;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoFromBytesFn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnnotateVideoTest {
    private static final String TEST_URI = "fake_uri";
    @Mock
    private VideoIntelligenceServiceClient serviceClient;
    @Mock
    private OperationFuture<AnnotateVideoResponse, AnnotateVideoProgress> future;
    @Mock
    private AnnotateVideoResponse response;

    @Test
    public void shouldReturnAListOfAnnotations() throws ExecutionException, InterruptedException {
        Mockito.when((Object)this.response.getAnnotationResultsList()).thenReturn(Collections.singletonList(VideoAnnotationResults.newBuilder().build()));
        Mockito.when((Object)((AnnotateVideoResponse)this.future.get())).thenReturn((Object)this.response);
        Mockito.when((Object)this.serviceClient.annotateVideoAsync((AnnotateVideoRequest)ArgumentMatchers.any())).thenReturn(this.future);
        AnnotateVideoFromBytesFn annotateVideoFromBytesFn = new AnnotateVideoFromBytesFn(null, Collections.singletonList(Feature.LABEL_DETECTION));
        annotateVideoFromBytesFn.videoIntelligenceServiceClient = this.serviceClient;
        List videoAnnotationResults = annotateVideoFromBytesFn.getVideoAnnotationResults(TEST_URI, null, null);
        Assert.assertEquals((long)1L, (long)videoAnnotationResults.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowErrorWhenBothInputTypesNull() throws ExecutionException, InterruptedException {
        AnnotateVideoFromBytesFn annotateVideoFromBytesFn = new AnnotateVideoFromBytesFn(null, Collections.singletonList(Feature.LABEL_DETECTION));
        annotateVideoFromBytesFn.getVideoAnnotationResults(null, null, null);
    }
}

