/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.language.v1.AnnotateTextRequest;
import com.google.cloud.language.v1.AnnotateTextResponse;
import com.google.cloud.language.v1.Document;
import java.util.ArrayList;
import org.apache.beam.sdk.extensions.ml.AnnotateText;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AnnotateTextIT {
    @Rule
    public TestPipeline testPipeline = TestPipeline.create();
    private static final String TEST_STRING = "Hello, world!";

    @Test
    public void analyzesLanguage() {
        Document doc = Document.newBuilder().setContent(TEST_STRING).setType(Document.Type.PLAIN_TEXT).build();
        AnnotateTextRequest.Features features = AnnotateTextRequest.Features.newBuilder().setExtractSyntax(true).build();
        PCollection responses = (PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Object)doc, (Object[])new Document[0]))).apply((PTransform)AnnotateText.newBuilder().setFeatures(features).build());
        PAssert.that((PCollection)responses).satisfies((SerializableFunction)new VerifyTextAnnotationResult());
        this.testPipeline.run().waitUntilFinish();
    }

    private static class VerifyTextAnnotationResult
    implements SerializableFunction<Iterable<AnnotateTextResponse>, Void> {
        private VerifyTextAnnotationResult() {
        }

        public Void apply(Iterable<AnnotateTextResponse> input) {
            ArrayList labelEvaluations = new ArrayList();
            input.forEach(response -> labelEvaluations.add(response.getLanguage().equalsIgnoreCase("en")));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)labelEvaluations.contains(Boolean.TRUE));
            return null;
        }
    }
}

