/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.vision.v1.AnnotateImageResponse;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.ml.AnnotateImages;
import org.apache.beam.sdk.extensions.ml.CloudVision;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnnotateImagesTest {
    @Mock
    private ImageAnnotatorClient imageAnnotatorClient;
    @Mock
    private BatchAnnotateImagesResponse response;

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnLargeBatchSize() {
        CloudVision.annotateImagesFromBytes(null, null, (long)20L, (int)0);
    }

    @Test
    public void shouldReturnAnnotationList() {
        Mockito.when((Object)this.response.getResponsesList()).thenReturn(Collections.singletonList(AnnotateImageResponse.newBuilder().build()));
        Mockito.when((Object)this.imageAnnotatorClient.batchAnnotateImages(ArgumentMatchers.anyList())).thenReturn((Object)this.response);
        AnnotateImages.PerformImageAnnotation performImageAnnotation = new AnnotateImages.PerformImageAnnotation(this.imageAnnotatorClient);
        List responseList = performImageAnnotation.getResponse(Collections.emptyList());
        Assert.assertEquals((long)1L, (long)responseList.size());
    }
}

