/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.videointelligence.v1.Feature;
import com.google.cloud.videointelligence.v1.VideoAnnotationResults;
import com.google.cloud.videointelligence.v1.VideoContext;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoBytesWithContextFn;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoFromBytesFn;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoFromURIFn;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoURIWithContextFn;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;

@Experimental
public class VideoIntelligence {
    public static AnnotateVideoFromUri annotateFromURI(List<Feature> featureList, PCollectionView<Map<String, VideoContext>> contextSideInput) {
        return new AnnotateVideoFromUri(contextSideInput, featureList);
    }

    public static AnnotateVideoFromBytes annotateFromBytes(PCollectionView<Map<ByteString, VideoContext>> contextSideInput, List<Feature> featureList) {
        return new AnnotateVideoFromBytes(contextSideInput, featureList);
    }

    public static AnnotateVideoFromURIWithContext annotateFromUriWithContext(List<Feature> featureList) {
        return new AnnotateVideoFromURIWithContext(featureList);
    }

    public static AnnotateVideoFromBytesWithContext annotateFromBytesWithContext(List<Feature> featureList) {
        return new AnnotateVideoFromBytesWithContext(featureList);
    }

    @Experimental
    public static class AnnotateVideoFromBytesWithContext
    extends PTransform<PCollection<KV<ByteString, VideoContext>>, PCollection<List<VideoAnnotationResults>>> {
        private final List<Feature> featureList;

        protected AnnotateVideoFromBytesWithContext(List<Feature> featureList) {
            this.featureList = featureList;
        }

        public PCollection<List<VideoAnnotationResults>> expand(PCollection<KV<ByteString, VideoContext>> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new AnnotateVideoBytesWithContextFn(this.featureList)));
        }
    }

    @Experimental
    public static class AnnotateVideoFromURIWithContext
    extends PTransform<PCollection<KV<String, VideoContext>>, PCollection<List<VideoAnnotationResults>>> {
        private final List<Feature> featureList;

        protected AnnotateVideoFromURIWithContext(List<Feature> featureList) {
            this.featureList = featureList;
        }

        public PCollection<List<VideoAnnotationResults>> expand(PCollection<KV<String, VideoContext>> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new AnnotateVideoURIWithContextFn(this.featureList)));
        }
    }

    @Experimental
    public static class AnnotateVideoFromBytes
    extends PTransform<PCollection<ByteString>, PCollection<List<VideoAnnotationResults>>> {
        private final PCollectionView<Map<ByteString, VideoContext>> contextSideInput;
        private final List<Feature> featureList;

        protected AnnotateVideoFromBytes(PCollectionView<Map<ByteString, VideoContext>> contextSideInput, List<Feature> featureList) {
            this.contextSideInput = contextSideInput;
            this.featureList = featureList;
        }

        public PCollection<List<VideoAnnotationResults>> expand(PCollection<ByteString> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new AnnotateVideoFromBytesFn(this.contextSideInput, this.featureList)));
        }
    }

    @Experimental
    public static class AnnotateVideoFromUri
    extends PTransform<PCollection<String>, PCollection<List<VideoAnnotationResults>>> {
        private final PCollectionView<Map<String, VideoContext>> contextSideInput;
        private final List<Feature> featureList;

        protected AnnotateVideoFromUri(PCollectionView<Map<String, VideoContext>> contextSideInput, List<Feature> featureList) {
            this.contextSideInput = contextSideInput;
            this.featureList = featureList;
        }

        public PCollection<List<VideoAnnotationResults>> expand(PCollection<String> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new AnnotateVideoFromURIFn(this.contextSideInput, this.featureList)));
        }
    }
}

