/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.privacy.dlp.v2.Table;
import com.google.privacy.dlp.v2.Value;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;

class MapStringToDlpRow
extends DoFn<KV<String, String>, KV<String, Table.Row>> {
    private final String delimiter;

    public MapStringToDlpRow(String delimiter) {
        this.delimiter = delimiter;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext context) {
        Table.Row.Builder rowBuilder = Table.Row.newBuilder();
        String line = Objects.requireNonNull((String)((KV)context.element()).getValue());
        if (this.delimiter != null) {
            List<String> values = Arrays.asList(line.split(this.delimiter));
            values.forEach(value -> rowBuilder.addValues(Value.newBuilder().setStringValue(value).build()));
        } else {
            rowBuilder.addValues(Value.newBuilder().setStringValue(line).build());
        }
        context.output((Object)KV.of((Object)((String)((KV)context.element()).getKey()), (Object)rowBuilder.build()));
    }
}

