/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.auto.value.AutoValue;
import com.google.cloud.dlp.v2.DlpServiceClient;
import com.google.privacy.dlp.v2.ContentItem;
import com.google.privacy.dlp.v2.DeidentifyConfig;
import com.google.privacy.dlp.v2.FieldId;
import com.google.privacy.dlp.v2.InspectConfig;
import com.google.privacy.dlp.v2.ProjectName;
import com.google.privacy.dlp.v2.ReidentifyContentRequest;
import com.google.privacy.dlp.v2.ReidentifyContentResponse;
import com.google.privacy.dlp.v2.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AutoValue_DLPReidentifyText;
import org.apache.beam.sdk.extensions.ml.BatchRequestForDLP;
import org.apache.beam.sdk.extensions.ml.MapStringToDlpRow;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental
@AutoValue
public abstract class DLPReidentifyText
extends PTransform<PCollection<KV<String, String>>, PCollection<KV<String, ReidentifyContentResponse>>> {
    public static final Integer DLP_PAYLOAD_LIMIT_BYTES = 524000;

    public abstract @Nullable String getInspectTemplateName();

    public abstract @Nullable String getReidentifyTemplateName();

    public abstract @Nullable InspectConfig getInspectConfig();

    public abstract @Nullable DeidentifyConfig getReidentifyConfig();

    public abstract @Nullable String getColumnDelimiter();

    public abstract @Nullable PCollectionView<List<String>> getHeaderColumns();

    public abstract Integer getBatchSizeBytes();

    public abstract String getProjectId();

    public static Builder newBuilder() {
        return new AutoValue_DLPReidentifyText.Builder();
    }

    public PCollection<KV<String, ReidentifyContentResponse>> expand(PCollection<KV<String, String>> input) {
        ParDo.SingleOutput reidentifyParDo = ParDo.of((DoFn)new ReidentifyText(this.getProjectId(), this.getInspectTemplateName(), this.getReidentifyTemplateName(), this.getInspectConfig(), this.getReidentifyConfig(), this.getHeaderColumns()));
        if (this.getHeaderColumns() != null) {
            reidentifyParDo = reidentifyParDo.withSideInputs(new PCollectionView[]{this.getHeaderColumns()});
        }
        return (PCollection)((PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new MapStringToDlpRow(this.getColumnDelimiter())))).apply("Batch Contents", (PTransform)ParDo.of((DoFn)new BatchRequestForDLP(this.getBatchSizeBytes())))).apply("DLPReidentify", (PTransform)reidentifyParDo);
    }

    static class ReidentifyText
    extends DoFn<KV<String, Iterable<Table.Row>>, KV<String, ReidentifyContentResponse>> {
        private final String projectId;
        private final String inspectTemplateName;
        private final String reidentifyTemplateName;
        private final InspectConfig inspectConfig;
        private final DeidentifyConfig reidentifyConfig;
        private final PCollectionView<List<String>> headerColumns;
        private transient ReidentifyContentRequest.Builder requestBuilder;
        private transient DlpServiceClient dlpServiceClient;

        @DoFn.Setup
        public void setup() throws IOException {
            this.requestBuilder = ReidentifyContentRequest.newBuilder().setParent(ProjectName.of((String)this.projectId).toString());
            if (this.inspectTemplateName != null) {
                this.requestBuilder.setInspectTemplateName(this.inspectTemplateName);
            }
            if (this.inspectConfig != null) {
                this.requestBuilder.setInspectConfig(this.inspectConfig);
            }
            if (this.reidentifyConfig != null) {
                this.requestBuilder.setReidentifyConfig(this.reidentifyConfig);
            }
            if (this.reidentifyTemplateName != null) {
                this.requestBuilder.setReidentifyTemplateName(this.reidentifyTemplateName);
            }
            this.dlpServiceClient = DlpServiceClient.create();
        }

        @DoFn.Teardown
        public void teardown() {
            this.dlpServiceClient.close();
        }

        public ReidentifyText(String projectId, String inspectTemplateName, String reidentifyTemplateName, InspectConfig inspectConfig, DeidentifyConfig reidentifyConfig, PCollectionView<List<String>> headerColumns) {
            this.projectId = projectId;
            this.inspectTemplateName = inspectTemplateName;
            this.reidentifyTemplateName = reidentifyTemplateName;
            this.inspectConfig = inspectConfig;
            this.reidentifyConfig = reidentifyConfig;
            this.headerColumns = headerColumns;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws IOException {
            List<Object> tableHeaders;
            if (this.headerColumns != null) {
                tableHeaders = ((List)context.sideInput(this.headerColumns)).stream().map(header -> FieldId.newBuilder().setName(header).build()).collect(Collectors.toList());
            } else {
                tableHeaders = new ArrayList<FieldId>();
                tableHeaders.add(FieldId.newBuilder().setName("value").build());
            }
            Table table = Table.newBuilder().addAllHeaders(tableHeaders).addAllRows((Iterable)((KV)context.element()).getValue()).build();
            ContentItem contentItem = ContentItem.newBuilder().setTable(table).build();
            this.requestBuilder.setItem(contentItem);
            ReidentifyContentResponse response = this.dlpServiceClient.reidentifyContent(this.requestBuilder.build());
            context.output((Object)KV.of((Object)((String)((KV)context.element()).getKey()), (Object)response));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setInspectTemplateName(String var1);

        public abstract Builder setInspectConfig(InspectConfig var1);

        public abstract Builder setReidentifyConfig(DeidentifyConfig var1);

        public abstract Builder setReidentifyTemplateName(String var1);

        public abstract Builder setBatchSizeBytes(Integer var1);

        public abstract Builder setHeaderColumns(PCollectionView<List<String>> var1);

        public abstract Builder setColumnDelimiter(String var1);

        public abstract Builder setProjectId(String var1);

        abstract DLPReidentifyText autoBuild();

        public DLPReidentifyText build() {
            DLPReidentifyText dlpReidentifyText = this.autoBuild();
            if (dlpReidentifyText.getReidentifyConfig() == null && dlpReidentifyText.getReidentifyTemplateName() == null) {
                throw new IllegalArgumentException("Either reidentifyConfig or reidentifyTemplateName need to be set!");
            }
            if (dlpReidentifyText.getBatchSizeBytes() > DLP_PAYLOAD_LIMIT_BYTES) {
                throw new IllegalArgumentException(String.format("Batch size is too large! It should be smaller or equal than %d.", DLP_PAYLOAD_LIMIT_BYTES));
            }
            if (dlpReidentifyText.getColumnDelimiter() == null && dlpReidentifyText.getHeaderColumns() != null) {
                throw new IllegalArgumentException("Column delimiter should be set if headers are present.");
            }
            if (dlpReidentifyText.getHeaderColumns() == null && dlpReidentifyText.getColumnDelimiter() != null) {
                throw new IllegalArgumentException("Column headers should be supplied when delimiter is present.");
            }
            return dlpReidentifyText;
        }
    }
}

