/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.auto.value.AutoValue;
import com.google.cloud.dlp.v2.DlpServiceClient;
import com.google.privacy.dlp.v2.ContentItem;
import com.google.privacy.dlp.v2.FieldId;
import com.google.privacy.dlp.v2.InspectConfig;
import com.google.privacy.dlp.v2.InspectContentRequest;
import com.google.privacy.dlp.v2.InspectContentResponse;
import com.google.privacy.dlp.v2.ProjectName;
import com.google.privacy.dlp.v2.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AutoValue_DLPInspectText;
import org.apache.beam.sdk.extensions.ml.BatchRequestForDLP;
import org.apache.beam.sdk.extensions.ml.MapStringToDlpRow;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental
@AutoValue
public abstract class DLPInspectText
extends PTransform<PCollection<KV<String, String>>, PCollection<KV<String, InspectContentResponse>>> {
    public static final Integer DLP_PAYLOAD_LIMIT_BYTES = 524000;

    public abstract @Nullable String getInspectTemplateName();

    public abstract @Nullable InspectConfig getInspectConfig();

    public abstract Integer getBatchSizeBytes();

    public abstract String getProjectId();

    public abstract @Nullable String getColumnDelimiter();

    public abstract @Nullable PCollectionView<List<String>> getHeaderColumns();

    public static Builder newBuilder() {
        return new AutoValue_DLPInspectText.Builder();
    }

    public PCollection<KV<String, InspectContentResponse>> expand(PCollection<KV<String, String>> input) {
        ParDo.SingleOutput inspectParDo = ParDo.of((DoFn)new InspectData(this.getProjectId(), this.getInspectTemplateName(), this.getInspectConfig(), this.getHeaderColumns()));
        if (this.getHeaderColumns() != null) {
            inspectParDo = inspectParDo.withSideInputs(new PCollectionView[]{this.getHeaderColumns()});
        }
        return (PCollection)((PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new MapStringToDlpRow(this.getColumnDelimiter())))).apply("Batch Contents", (PTransform)ParDo.of((DoFn)new BatchRequestForDLP(this.getBatchSizeBytes())))).apply("DLPInspect", (PTransform)inspectParDo);
    }

    static class InspectData
    extends DoFn<KV<String, Iterable<Table.Row>>, KV<String, InspectContentResponse>> {
        private final String projectId;
        private final String inspectTemplateName;
        private final InspectConfig inspectConfig;
        private final PCollectionView<List<String>> headerColumns;
        private transient DlpServiceClient dlpServiceClient;
        private transient InspectContentRequest.Builder requestBuilder;

        public InspectData(String projectId, String inspectTemplateName, InspectConfig inspectConfig, PCollectionView<List<String>> headerColumns) {
            this.projectId = projectId;
            this.inspectTemplateName = inspectTemplateName;
            this.inspectConfig = inspectConfig;
            this.headerColumns = headerColumns;
        }

        @DoFn.Setup
        public void setup() throws IOException {
            this.requestBuilder = InspectContentRequest.newBuilder().setParent(ProjectName.of((String)this.projectId).toString());
            if (this.inspectTemplateName != null) {
                this.requestBuilder.setInspectTemplateName(this.inspectTemplateName);
            }
            if (this.inspectConfig != null) {
                this.requestBuilder.setInspectConfig(this.inspectConfig);
            }
            this.dlpServiceClient = DlpServiceClient.create();
        }

        @DoFn.Teardown
        public void teardown() {
            this.dlpServiceClient.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws IOException {
            List<Object> tableHeaders;
            if (this.headerColumns != null) {
                tableHeaders = ((List)c.sideInput(this.headerColumns)).stream().map(header -> FieldId.newBuilder().setName(header).build()).collect(Collectors.toList());
            } else {
                tableHeaders = new ArrayList<FieldId>();
                tableHeaders.add(FieldId.newBuilder().setName("value").build());
            }
            Table table = Table.newBuilder().addAllHeaders(tableHeaders).addAllRows((Iterable)((KV)c.element()).getValue()).build();
            ContentItem contentItem = ContentItem.newBuilder().setTable(table).build();
            this.requestBuilder.setItem(contentItem);
            InspectContentResponse response = this.dlpServiceClient.inspectContent(this.requestBuilder.build());
            c.output((Object)KV.of((Object)((String)((KV)c.element()).getKey()), (Object)response));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setInspectTemplateName(String var1);

        public abstract Builder setInspectConfig(InspectConfig var1);

        public abstract Builder setBatchSizeBytes(Integer var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder setColumnDelimiter(String var1);

        public abstract Builder setHeaderColumns(PCollectionView<List<String>> var1);

        abstract DLPInspectText autoBuild();

        public DLPInspectText build() {
            DLPInspectText inspectText = this.autoBuild();
            if (inspectText.getInspectTemplateName() == null && inspectText.getInspectConfig() == null) {
                throw new IllegalArgumentException("Either inspectTemplateName or inspectConfig must be supplied!");
            }
            if (inspectText.getBatchSizeBytes() > DLP_PAYLOAD_LIMIT_BYTES) {
                throw new IllegalArgumentException(String.format("Batch size is too large! It should be smaller or equal than %d.", DLP_PAYLOAD_LIMIT_BYTES));
            }
            if (inspectText.getColumnDelimiter() == null && inspectText.getHeaderColumns() != null) {
                throw new IllegalArgumentException("Column delimiter should be set if headers are present.");
            }
            if (inspectText.getHeaderColumns() == null && inspectText.getColumnDelimiter() != null) {
                throw new IllegalArgumentException("Column headers should be supplied when delimiter is present.");
            }
            return inspectText;
        }
    }
}

