/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.auto.value.AutoValue;
import com.google.cloud.dlp.v2.DlpServiceClient;
import com.google.privacy.dlp.v2.ContentItem;
import com.google.privacy.dlp.v2.DeidentifyConfig;
import com.google.privacy.dlp.v2.DeidentifyContentRequest;
import com.google.privacy.dlp.v2.DeidentifyContentResponse;
import com.google.privacy.dlp.v2.FieldId;
import com.google.privacy.dlp.v2.InspectConfig;
import com.google.privacy.dlp.v2.ProjectName;
import com.google.privacy.dlp.v2.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AutoValue_DLPDeidentifyText;
import org.apache.beam.sdk.extensions.ml.BatchRequestForDLP;
import org.apache.beam.sdk.extensions.ml.MapStringToDlpRow;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental
@AutoValue
public abstract class DLPDeidentifyText
extends PTransform<PCollection<KV<String, String>>, PCollection<KV<String, DeidentifyContentResponse>>> {
    public static final Integer DLP_PAYLOAD_LIMIT_BYTES = 524000;

    public abstract @Nullable String getInspectTemplateName();

    public abstract @Nullable String getDeidentifyTemplateName();

    public abstract @Nullable InspectConfig getInspectConfig();

    public abstract @Nullable DeidentifyConfig getDeidentifyConfig();

    public abstract @Nullable PCollectionView<List<String>> getHeaderColumns();

    public abstract @Nullable String getColumnDelimiter();

    public abstract Integer getBatchSizeBytes();

    public abstract String getProjectId();

    public static Builder newBuilder() {
        return new AutoValue_DLPDeidentifyText.Builder();
    }

    public PCollection<KV<String, DeidentifyContentResponse>> expand(PCollection<KV<String, String>> input) {
        ParDo.SingleOutput deidentifyParDo = ParDo.of((DoFn)new DeidentifyText(this.getProjectId(), this.getInspectTemplateName(), this.getDeidentifyTemplateName(), this.getInspectConfig(), this.getDeidentifyConfig(), this.getHeaderColumns()));
        if (this.getHeaderColumns() != null) {
            deidentifyParDo = deidentifyParDo.withSideInputs(new PCollectionView[]{this.getHeaderColumns()});
        }
        return (PCollection)((PCollection)((PCollection)input.apply((PTransform)ParDo.of((DoFn)new MapStringToDlpRow(this.getColumnDelimiter())))).apply("Batch Contents", (PTransform)ParDo.of((DoFn)new BatchRequestForDLP(this.getBatchSizeBytes())))).apply("DLPDeidentify", (PTransform)deidentifyParDo);
    }

    static class DeidentifyText
    extends DoFn<KV<String, Iterable<Table.Row>>, KV<String, DeidentifyContentResponse>> {
        private final String projectId;
        private final String inspectTemplateName;
        private final String deidentifyTemplateName;
        private final InspectConfig inspectConfig;
        private final DeidentifyConfig deidentifyConfig;
        private final PCollectionView<List<String>> headerColumns;
        private transient DeidentifyContentRequest.Builder requestBuilder;
        private transient DlpServiceClient dlpServiceClient;

        @DoFn.Setup
        public void setup() throws IOException {
            this.requestBuilder = DeidentifyContentRequest.newBuilder().setParent(ProjectName.of((String)this.projectId).toString());
            if (this.inspectTemplateName != null) {
                this.requestBuilder.setInspectTemplateName(this.inspectTemplateName);
            }
            if (this.inspectConfig != null) {
                this.requestBuilder.setInspectConfig(this.inspectConfig);
            }
            if (this.deidentifyConfig != null) {
                this.requestBuilder.setDeidentifyConfig(this.deidentifyConfig);
            }
            if (this.deidentifyTemplateName != null) {
                this.requestBuilder.setDeidentifyTemplateName(this.deidentifyTemplateName);
            }
            this.dlpServiceClient = DlpServiceClient.create();
        }

        @DoFn.Teardown
        public void teardown() {
            this.dlpServiceClient.close();
        }

        public DeidentifyText(String projectId, String inspectTemplateName, String deidentifyTemplateName, InspectConfig inspectConfig, DeidentifyConfig deidentifyConfig, PCollectionView<List<String>> headerColumns) {
            this.projectId = projectId;
            this.inspectTemplateName = inspectTemplateName;
            this.deidentifyTemplateName = deidentifyTemplateName;
            this.inspectConfig = inspectConfig;
            this.deidentifyConfig = deidentifyConfig;
            this.headerColumns = headerColumns;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws IOException {
            List<Object> dlpTableHeaders;
            String fileName = (String)((KV)c.element()).getKey();
            if (this.headerColumns != null) {
                dlpTableHeaders = ((List)c.sideInput(this.headerColumns)).stream().map(header -> FieldId.newBuilder().setName(header).build()).collect(Collectors.toList());
            } else {
                dlpTableHeaders = new ArrayList<FieldId>();
                dlpTableHeaders.add(FieldId.newBuilder().setName("value").build());
            }
            Table table = Table.newBuilder().addAllHeaders(dlpTableHeaders).addAllRows((Iterable)((KV)c.element()).getValue()).build();
            ContentItem contentItem = ContentItem.newBuilder().setTable(table).build();
            this.requestBuilder.setItem(contentItem);
            DeidentifyContentResponse response = this.dlpServiceClient.deidentifyContent(this.requestBuilder.build());
            c.output((Object)KV.of((Object)fileName, (Object)response));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setInspectTemplateName(String var1);

        public abstract Builder setHeaderColumns(PCollectionView<List<String>> var1);

        public abstract Builder setColumnDelimiter(String var1);

        public abstract Builder setBatchSizeBytes(Integer var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder setDeidentifyTemplateName(String var1);

        public abstract Builder setInspectConfig(InspectConfig var1);

        public abstract Builder setDeidentifyConfig(DeidentifyConfig var1);

        abstract DLPDeidentifyText autoBuild();

        public DLPDeidentifyText build() {
            DLPDeidentifyText dlpDeidentifyText = this.autoBuild();
            if (dlpDeidentifyText.getDeidentifyConfig() == null && dlpDeidentifyText.getDeidentifyTemplateName() == null) {
                throw new IllegalArgumentException("Either deidentifyConfig or deidentifyTemplateName need to be set!");
            }
            if (dlpDeidentifyText.getBatchSizeBytes() > DLP_PAYLOAD_LIMIT_BYTES) {
                throw new IllegalArgumentException(String.format("Batch size is too large! It should be smaller or equal than %d.", DLP_PAYLOAD_LIMIT_BYTES));
            }
            if (dlpDeidentifyText.getColumnDelimiter() == null && dlpDeidentifyText.getHeaderColumns() != null) {
                throw new IllegalArgumentException("Column delimiter should be set if headers are present.");
            }
            if (dlpDeidentifyText.getHeaderColumns() == null && dlpDeidentifyText.getColumnDelimiter() != null) {
                throw new IllegalArgumentException("Column headers should be supplied when delimiter is present.");
            }
            return dlpDeidentifyText;
        }
    }
}

