/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.vision.v1.AnnotateImageRequest;
import com.google.cloud.vision.v1.Feature;
import com.google.cloud.vision.v1.Image;
import com.google.cloud.vision.v1.ImageContext;
import com.google.cloud.vision.v1.ImageSource;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AnnotateImages;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental
public class CloudVision {
    private static final int DEFAULT_PARALLELISM = 5;

    public static AnnotateImagesFromGcsUri annotateImagesFromGcsUri(PCollectionView<Map<String, ImageContext>> contextSideInput, List<Feature> features, long batchSize, int desiredRequestParallelism) {
        return new AnnotateImagesFromGcsUri(contextSideInput, features, batchSize, desiredRequestParallelism);
    }

    public static AnnotateImagesFromGcsUri annotateImagesFromGcsUri(PCollectionView<Map<String, ImageContext>> contextSideInput, List<Feature> features, long batchSize) {
        return CloudVision.annotateImagesFromGcsUri(contextSideInput, features, batchSize, 5);
    }

    public static AnnotateImagesFromBytes annotateImagesFromBytes(PCollectionView<Map<ByteString, ImageContext>> contextSideInput, List<Feature> features, long batchSize, int desiredRequestParallelism) {
        return new AnnotateImagesFromBytes(contextSideInput, features, batchSize, desiredRequestParallelism);
    }

    public static AnnotateImagesFromBytes annotateImagesFromBytes(PCollectionView<Map<ByteString, ImageContext>> contextSideInput, List<Feature> features, long batchSize) {
        return CloudVision.annotateImagesFromBytes(contextSideInput, features, batchSize, 5);
    }

    public static AnnotateImagesFromBytesWithContext annotateImagesFromBytesWithContext(List<Feature> features, long batchSize, int desiredRequestParallelism) {
        return new AnnotateImagesFromBytesWithContext(features, batchSize, desiredRequestParallelism);
    }

    public static AnnotateImagesFromBytesWithContext annotateImagesFromBytesWithContext(List<Feature> features, long batchSize) {
        return CloudVision.annotateImagesFromBytesWithContext(features, batchSize, 5);
    }

    public static AnnotateImagesFromGcsUriWithContext annotateImagesFromGcsUriWithContext(List<Feature> features, long batchSize, int desiredRequestParallelism) {
        return new AnnotateImagesFromGcsUriWithContext(features, batchSize, desiredRequestParallelism);
    }

    public static AnnotateImagesFromGcsUriWithContext annotateImagesFromGcsUriWithContext(List<Feature> features, long batchSize) {
        return CloudVision.annotateImagesFromGcsUriWithContext(features, batchSize, 5);
    }

    public static class AnnotateImagesFromBytesWithContext
    extends AnnotateImages<KV<ByteString, ImageContext>> {
        public AnnotateImagesFromBytesWithContext(List<Feature> featureList, long batchSize, int desiredRequestParallelism) {
            super(featureList, batchSize, desiredRequestParallelism);
        }

        @Override
        public AnnotateImageRequest mapToRequest(KV<ByteString, ImageContext> input, @Nullable ImageContext ctx) {
            Image image = Image.newBuilder().setContent((ByteString)input.getKey()).build();
            AnnotateImageRequest.Builder builder = AnnotateImageRequest.newBuilder().setImage(image).addAllFeatures((Iterable)this.featureList);
            if (input.getValue() != null) {
                builder.setImageContext((ImageContext)input.getValue());
            }
            return builder.build();
        }
    }

    public static class AnnotateImagesFromGcsUriWithContext
    extends AnnotateImages<KV<String, ImageContext>> {
        public AnnotateImagesFromGcsUriWithContext(List<Feature> featureList, long batchSize, int desiredRequestParallelism) {
            super(featureList, batchSize, desiredRequestParallelism);
        }

        @Override
        public AnnotateImageRequest mapToRequest(KV<String, ImageContext> input, @Nullable ImageContext ctx) {
            ImageSource imageSource = ImageSource.newBuilder().setGcsImageUri((String)input.getKey()).build();
            Image image = Image.newBuilder().setSource(imageSource).build();
            AnnotateImageRequest.Builder builder = AnnotateImageRequest.newBuilder().setImage(image).addAllFeatures((Iterable)this.featureList);
            if (input.getValue() != null) {
                builder.setImageContext((ImageContext)input.getValue());
            }
            return builder.build();
        }
    }

    public static class AnnotateImagesFromBytes
    extends AnnotateImages<ByteString> {
        public AnnotateImagesFromBytes(PCollectionView<Map<ByteString, ImageContext>> contextSideInput, List<Feature> featureList, long batchSize, int desiredRequestParallelism) {
            super(contextSideInput, featureList, batchSize, desiredRequestParallelism);
        }

        @Override
        public AnnotateImageRequest mapToRequest(ByteString input, @Nullable ImageContext ctx) {
            AnnotateImageRequest.Builder builder = AnnotateImageRequest.newBuilder();
            if (ctx != null) {
                builder.setImageContext(ctx);
            }
            return builder.addAllFeatures((Iterable)this.featureList).setImage(Image.newBuilder().setContent(input).build()).build();
        }
    }

    public static class AnnotateImagesFromGcsUri
    extends AnnotateImages<String> {
        public AnnotateImagesFromGcsUri(PCollectionView<Map<String, ImageContext>> contextSideInput, List<Feature> featureList, long batchSize, int desiredRequestParallelism) {
            super(contextSideInput, featureList, batchSize, desiredRequestParallelism);
        }

        @Override
        public AnnotateImageRequest mapToRequest(String uri, @Nullable ImageContext ctx) {
            AnnotateImageRequest.Builder builder = AnnotateImageRequest.newBuilder();
            if (ctx != null) {
                builder.setImageContext(ctx);
            }
            ImageSource imgSource = ImageSource.newBuilder().setGcsImageUri(uri).build();
            return builder.addAllFeatures((Iterable)this.featureList).setImage(Image.newBuilder().setSource(imgSource).build()).build();
        }
    }
}

