/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.privacy.dlp.v2.InspectConfig;
import java.util.List;
import org.apache.beam.sdk.extensions.ml.DLPInspectText;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_DLPInspectText
extends DLPInspectText {
    private final @Nullable String inspectTemplateName;
    private final @Nullable InspectConfig inspectConfig;
    private final Integer batchSizeBytes;
    private final String projectId;
    private final @Nullable String columnDelimiter;
    private final @Nullable PCollectionView<List<String>> headerColumns;

    private AutoValue_DLPInspectText(@Nullable String inspectTemplateName, @Nullable InspectConfig inspectConfig, Integer batchSizeBytes, String projectId, @Nullable String columnDelimiter, @Nullable PCollectionView<List<String>> headerColumns) {
        this.inspectTemplateName = inspectTemplateName;
        this.inspectConfig = inspectConfig;
        this.batchSizeBytes = batchSizeBytes;
        this.projectId = projectId;
        this.columnDelimiter = columnDelimiter;
        this.headerColumns = headerColumns;
    }

    @Override
    public @Nullable String getInspectTemplateName() {
        return this.inspectTemplateName;
    }

    @Override
    public @Nullable InspectConfig getInspectConfig() {
        return this.inspectConfig;
    }

    @Override
    public Integer getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public @Nullable String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    @Override
    public @Nullable PCollectionView<List<String>> getHeaderColumns() {
        return this.headerColumns;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DLPInspectText) {
            DLPInspectText that = (DLPInspectText)((Object)o);
            return (this.inspectTemplateName == null ? that.getInspectTemplateName() == null : this.inspectTemplateName.equals(that.getInspectTemplateName())) && (this.inspectConfig == null ? that.getInspectConfig() == null : this.inspectConfig.equals((Object)that.getInspectConfig())) && this.batchSizeBytes.equals(that.getBatchSizeBytes()) && this.projectId.equals(that.getProjectId()) && (this.columnDelimiter == null ? that.getColumnDelimiter() == null : this.columnDelimiter.equals(that.getColumnDelimiter())) && (this.headerColumns == null ? that.getHeaderColumns() == null : this.headerColumns.equals(that.getHeaderColumns()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.inspectTemplateName == null ? 0 : this.inspectTemplateName.hashCode();
        h$ *= 1000003;
        h$ ^= this.inspectConfig == null ? 0 : this.inspectConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchSizeBytes.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.columnDelimiter == null ? 0 : this.columnDelimiter.hashCode();
        h$ *= 1000003;
        return h$ ^= this.headerColumns == null ? 0 : this.headerColumns.hashCode();
    }

    static final class Builder
    extends DLPInspectText.Builder {
        private @Nullable String inspectTemplateName;
        private @Nullable InspectConfig inspectConfig;
        private Integer batchSizeBytes;
        private String projectId;
        private @Nullable String columnDelimiter;
        private @Nullable PCollectionView<List<String>> headerColumns;

        Builder() {
        }

        @Override
        public DLPInspectText.Builder setInspectTemplateName(String inspectTemplateName) {
            this.inspectTemplateName = inspectTemplateName;
            return this;
        }

        @Override
        public DLPInspectText.Builder setInspectConfig(InspectConfig inspectConfig) {
            this.inspectConfig = inspectConfig;
            return this;
        }

        @Override
        public DLPInspectText.Builder setBatchSizeBytes(Integer batchSizeBytes) {
            if (batchSizeBytes == null) {
                throw new NullPointerException("Null batchSizeBytes");
            }
            this.batchSizeBytes = batchSizeBytes;
            return this;
        }

        @Override
        public DLPInspectText.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        public DLPInspectText.Builder setColumnDelimiter(String columnDelimiter) {
            this.columnDelimiter = columnDelimiter;
            return this;
        }

        @Override
        public DLPInspectText.Builder setHeaderColumns(PCollectionView<List<String>> headerColumns) {
            this.headerColumns = headerColumns;
            return this;
        }

        @Override
        DLPInspectText autoBuild() {
            String missing = "";
            if (this.batchSizeBytes == null) {
                missing = missing + " batchSizeBytes";
            }
            if (this.projectId == null) {
                missing = missing + " projectId";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DLPInspectText(this.inspectTemplateName, this.inspectConfig, this.batchSizeBytes, this.projectId, this.columnDelimiter, this.headerColumns);
        }
    }
}

