/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.privacy.dlp.v2.DeidentifyConfig;
import com.google.privacy.dlp.v2.InspectConfig;
import java.util.List;
import org.apache.beam.sdk.extensions.ml.DLPDeidentifyText;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_DLPDeidentifyText
extends DLPDeidentifyText {
    private final @Nullable String inspectTemplateName;
    private final @Nullable String deidentifyTemplateName;
    private final @Nullable InspectConfig inspectConfig;
    private final @Nullable DeidentifyConfig deidentifyConfig;
    private final @Nullable PCollectionView<List<String>> headerColumns;
    private final @Nullable String columnDelimiter;
    private final Integer batchSizeBytes;
    private final String projectId;

    private AutoValue_DLPDeidentifyText(@Nullable String inspectTemplateName, @Nullable String deidentifyTemplateName, @Nullable InspectConfig inspectConfig, @Nullable DeidentifyConfig deidentifyConfig, @Nullable PCollectionView<List<String>> headerColumns, @Nullable String columnDelimiter, Integer batchSizeBytes, String projectId) {
        this.inspectTemplateName = inspectTemplateName;
        this.deidentifyTemplateName = deidentifyTemplateName;
        this.inspectConfig = inspectConfig;
        this.deidentifyConfig = deidentifyConfig;
        this.headerColumns = headerColumns;
        this.columnDelimiter = columnDelimiter;
        this.batchSizeBytes = batchSizeBytes;
        this.projectId = projectId;
    }

    @Override
    public @Nullable String getInspectTemplateName() {
        return this.inspectTemplateName;
    }

    @Override
    public @Nullable String getDeidentifyTemplateName() {
        return this.deidentifyTemplateName;
    }

    @Override
    public @Nullable InspectConfig getInspectConfig() {
        return this.inspectConfig;
    }

    @Override
    public @Nullable DeidentifyConfig getDeidentifyConfig() {
        return this.deidentifyConfig;
    }

    @Override
    public @Nullable PCollectionView<List<String>> getHeaderColumns() {
        return this.headerColumns;
    }

    @Override
    public @Nullable String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    @Override
    public Integer getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DLPDeidentifyText) {
            DLPDeidentifyText that = (DLPDeidentifyText)((Object)o);
            return (this.inspectTemplateName == null ? that.getInspectTemplateName() == null : this.inspectTemplateName.equals(that.getInspectTemplateName())) && (this.deidentifyTemplateName == null ? that.getDeidentifyTemplateName() == null : this.deidentifyTemplateName.equals(that.getDeidentifyTemplateName())) && (this.inspectConfig == null ? that.getInspectConfig() == null : this.inspectConfig.equals((Object)that.getInspectConfig())) && (this.deidentifyConfig == null ? that.getDeidentifyConfig() == null : this.deidentifyConfig.equals((Object)that.getDeidentifyConfig())) && (this.headerColumns == null ? that.getHeaderColumns() == null : this.headerColumns.equals(that.getHeaderColumns())) && (this.columnDelimiter == null ? that.getColumnDelimiter() == null : this.columnDelimiter.equals(that.getColumnDelimiter())) && this.batchSizeBytes.equals(that.getBatchSizeBytes()) && this.projectId.equals(that.getProjectId());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.inspectTemplateName == null ? 0 : this.inspectTemplateName.hashCode();
        h$ *= 1000003;
        h$ ^= this.deidentifyTemplateName == null ? 0 : this.deidentifyTemplateName.hashCode();
        h$ *= 1000003;
        h$ ^= this.inspectConfig == null ? 0 : this.inspectConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.deidentifyConfig == null ? 0 : this.deidentifyConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.headerColumns == null ? 0 : this.headerColumns.hashCode();
        h$ *= 1000003;
        h$ ^= this.columnDelimiter == null ? 0 : this.columnDelimiter.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchSizeBytes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.projectId.hashCode();
    }

    static final class Builder
    extends DLPDeidentifyText.Builder {
        private @Nullable String inspectTemplateName;
        private @Nullable String deidentifyTemplateName;
        private @Nullable InspectConfig inspectConfig;
        private @Nullable DeidentifyConfig deidentifyConfig;
        private @Nullable PCollectionView<List<String>> headerColumns;
        private @Nullable String columnDelimiter;
        private Integer batchSizeBytes;
        private String projectId;

        Builder() {
        }

        @Override
        public DLPDeidentifyText.Builder setInspectTemplateName(String inspectTemplateName) {
            this.inspectTemplateName = inspectTemplateName;
            return this;
        }

        @Override
        public DLPDeidentifyText.Builder setDeidentifyTemplateName(String deidentifyTemplateName) {
            this.deidentifyTemplateName = deidentifyTemplateName;
            return this;
        }

        @Override
        public DLPDeidentifyText.Builder setInspectConfig(InspectConfig inspectConfig) {
            this.inspectConfig = inspectConfig;
            return this;
        }

        @Override
        public DLPDeidentifyText.Builder setDeidentifyConfig(DeidentifyConfig deidentifyConfig) {
            this.deidentifyConfig = deidentifyConfig;
            return this;
        }

        @Override
        public DLPDeidentifyText.Builder setHeaderColumns(PCollectionView<List<String>> headerColumns) {
            this.headerColumns = headerColumns;
            return this;
        }

        @Override
        public DLPDeidentifyText.Builder setColumnDelimiter(String columnDelimiter) {
            this.columnDelimiter = columnDelimiter;
            return this;
        }

        @Override
        public DLPDeidentifyText.Builder setBatchSizeBytes(Integer batchSizeBytes) {
            if (batchSizeBytes == null) {
                throw new NullPointerException("Null batchSizeBytes");
            }
            this.batchSizeBytes = batchSizeBytes;
            return this;
        }

        @Override
        public DLPDeidentifyText.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        DLPDeidentifyText autoBuild() {
            String missing = "";
            if (this.batchSizeBytes == null) {
                missing = missing + " batchSizeBytes";
            }
            if (this.projectId == null) {
                missing = missing + " projectId";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DLPDeidentifyText(this.inspectTemplateName, this.deidentifyTemplateName, this.inspectConfig, this.deidentifyConfig, this.headerColumns, this.columnDelimiter, this.batchSizeBytes, this.projectId);
        }
    }
}

