/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.videointelligence.v1.Feature;
import com.google.cloud.videointelligence.v1.VideoAnnotationResults;
import com.google.cloud.videointelligence.v1.VideoContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoFn;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;

@Experimental
class AnnotateVideoFromURIFn
extends AnnotateVideoFn<String> {
    public AnnotateVideoFromURIFn(PCollectionView<Map<String, VideoContext>> contextSideInput, List<Feature> featureList) {
        super(contextSideInput, featureList);
    }

    @Override
    public void processElement(DoFn.ProcessContext context) throws ExecutionException, InterruptedException {
        String elementURI = (String)context.element();
        VideoContext videoContext = null;
        if (this.contextSideInput != null) {
            videoContext = (VideoContext)((Map)context.sideInput(this.contextSideInput)).get(elementURI);
        }
        List<VideoAnnotationResults> annotationResultsList = this.getVideoAnnotationResults(elementURI, null, videoContext);
        context.output(annotationResultsList);
    }
}

