/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.videointelligence.v1.Feature;
import com.google.cloud.videointelligence.v1.VideoAnnotationResults;
import com.google.cloud.videointelligence.v1.VideoContext;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AnnotateVideoFn;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;

@Experimental
class AnnotateVideoFromBytesFn
extends AnnotateVideoFn<ByteString> {
    public AnnotateVideoFromBytesFn(PCollectionView<Map<ByteString, VideoContext>> contextSideInput, List<Feature> featureList) {
        super(contextSideInput, featureList);
    }

    @Override
    public void processElement(DoFn.ProcessContext context) throws ExecutionException, InterruptedException {
        ByteString element = (ByteString)context.element();
        VideoContext videoContext = null;
        if (this.contextSideInput != null) {
            videoContext = (VideoContext)((Map)context.sideInput(this.contextSideInput)).get(element);
        }
        List<VideoAnnotationResults> videoAnnotationResults = this.getVideoAnnotationResults(null, element, videoContext);
        context.output(videoAnnotationResults);
    }
}

