/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.videointelligence.v1.AnnotateVideoRequest;
import com.google.cloud.videointelligence.v1.AnnotateVideoResponse;
import com.google.cloud.videointelligence.v1.Feature;
import com.google.cloud.videointelligence.v1.VideoAnnotationResults;
import com.google.cloud.videointelligence.v1.VideoContext;
import com.google.cloud.videointelligence.v1.VideoIntelligenceServiceClient;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.PCollectionView;

@Experimental
abstract class AnnotateVideoFn<T>
extends DoFn<T, List<VideoAnnotationResults>> {
    protected final PCollectionView<Map<T, VideoContext>> contextSideInput;
    protected final List<Feature> featureList;
    VideoIntelligenceServiceClient videoIntelligenceServiceClient;

    public AnnotateVideoFn(PCollectionView<Map<T, VideoContext>> contextSideInput, List<Feature> featureList) {
        this.contextSideInput = contextSideInput;
        this.featureList = featureList;
    }

    public AnnotateVideoFn(List<Feature> featureList) {
        this.contextSideInput = null;
        this.featureList = featureList;
    }

    @DoFn.Setup
    public void setup() throws IOException {
        this.videoIntelligenceServiceClient = VideoIntelligenceServiceClient.create();
    }

    @DoFn.Teardown
    public void teardown() {
        this.videoIntelligenceServiceClient.close();
    }

    List<VideoAnnotationResults> getVideoAnnotationResults(String elementURI, ByteString elementContents, VideoContext videoContext) throws InterruptedException, ExecutionException {
        AnnotateVideoRequest.Builder requestBuilder = AnnotateVideoRequest.newBuilder().addAllFeatures(this.featureList);
        if (elementURI != null) {
            requestBuilder.setInputUri(elementURI);
        } else if (elementContents != null) {
            requestBuilder.setInputContent(elementContents);
        } else {
            throw new IllegalArgumentException("Either elementURI or elementContents should be non-null");
        }
        if (videoContext != null) {
            requestBuilder.setVideoContext(videoContext);
        }
        AnnotateVideoRequest annotateVideoRequest = requestBuilder.build();
        OperationFuture annotateVideoAsync = this.videoIntelligenceServiceClient.annotateVideoAsync(annotateVideoRequest);
        return ((AnnotateVideoResponse)annotateVideoAsync.get()).getAnnotationResultsList();
    }

    @DoFn.ProcessElement
    public abstract void processElement(DoFn.ProcessContext var1) throws ExecutionException, InterruptedException;
}

