/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.auto.value.AutoValue;
import com.google.cloud.language.v1.AnnotateTextRequest;
import com.google.cloud.language.v1.AnnotateTextResponse;
import com.google.cloud.language.v1.Document;
import com.google.cloud.language.v1.LanguageServiceClient;
import java.io.IOException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.ml.AutoValue_AnnotateText;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental
@AutoValue
public abstract class AnnotateText
extends PTransform<PCollection<Document>, PCollection<AnnotateTextResponse>> {
    public abstract @Nullable String languageHint();

    public abstract AnnotateTextRequest.Features features();

    public static Builder newBuilder() {
        return new AutoValue_AnnotateText.Builder();
    }

    public PCollection<AnnotateTextResponse> expand(PCollection<Document> input) {
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new CallLanguageApi(this.languageHint(), this.features())));
    }

    private static class CallLanguageApi
    extends DoFn<Document, AnnotateTextResponse> {
        private final String languageHint;
        private final AnnotateTextRequest.Features features;

        private CallLanguageApi(String languageHint, AnnotateTextRequest.Features features) {
            this.languageHint = languageHint;
            this.features = features;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws IOException {
            try (LanguageServiceClient client = LanguageServiceClient.create();){
                Document element = (Document)context.element();
                if (this.languageHint != null) {
                    element = element.toBuilder().setLanguage(this.languageHint).build();
                }
                AnnotateTextResponse output = client.annotateText(element, this.features);
                context.output((Object)output);
            }
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setLanguageHint(String var1);

        public abstract Builder setFeatures(AnnotateTextRequest.Features var1);

        public abstract AnnotateText build();
    }
}

