/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.ml;

import com.google.cloud.vision.v1.AnnotateImageRequest;
import com.google.cloud.vision.v1.AnnotateImageResponse;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.Feature;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import com.google.cloud.vision.v1.ImageContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental
abstract class AnnotateImages<T>
extends PTransform<PCollection<T>, PCollection<List<AnnotateImageResponse>>> {
    private static final Long MIN_BATCH_SIZE = 1L;
    private static final Long MAX_BATCH_SIZE = 16L;
    protected final PCollectionView<Map<T, ImageContext>> contextSideInput;
    protected final List<Feature> featureList;
    private final long batchSize;
    protected final int desiredRequestParallelism;

    public AnnotateImages(@Nullable PCollectionView<Map<T, ImageContext>> contextSideInput, List<Feature> featureList, long batchSize, int desiredRequestParallelism) {
        this.contextSideInput = contextSideInput;
        this.featureList = featureList;
        this.desiredRequestParallelism = desiredRequestParallelism;
        this.checkBatchSizeCorrectness(batchSize);
        this.batchSize = batchSize;
    }

    public AnnotateImages(List<Feature> featureList, long batchSize, int desiredRequestParallelism) {
        this.desiredRequestParallelism = desiredRequestParallelism;
        this.contextSideInput = null;
        this.featureList = featureList;
        this.checkBatchSizeCorrectness(batchSize);
        this.batchSize = batchSize;
    }

    private void checkBatchSizeCorrectness(long batchSize) {
        if (batchSize > MAX_BATCH_SIZE) {
            throw new IllegalArgumentException(String.format("Max batch size exceeded.%nBatch size needs to be equal or smaller than %d", MAX_BATCH_SIZE));
        }
        if (batchSize < MIN_BATCH_SIZE) {
            throw new IllegalArgumentException(String.format("Min batch size not reached.%nBatch size needs to be larger or equal than %d", MIN_BATCH_SIZE));
        }
    }

    public PCollection<List<AnnotateImageResponse>> expand(PCollection<T> input) {
        ParDo.SingleOutput inputToRequestMapper = this.contextSideInput != null ? ParDo.of((DoFn)new MapInputToRequest(this.contextSideInput)).withSideInputs(new PCollectionView[]{this.contextSideInput}) : ParDo.of((DoFn)new MapInputToRequest(null));
        return (PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)inputToRequestMapper)).apply((PTransform)WithKeys.of((SerializableFunction & Serializable)ignored -> new Random().nextInt(this.desiredRequestParallelism)).withKeyType(TypeDescriptors.integers()))).apply((PTransform)GroupIntoBatches.ofSize((long)this.batchSize))).apply((PTransform)ParDo.of((DoFn)new PerformImageAnnotation()));
    }

    public abstract AnnotateImageRequest mapToRequest(T var1, @Nullable ImageContext var2);

    private class MapInputToRequest
    extends DoFn<T, AnnotateImageRequest> {
        PCollectionView<Map<T, ImageContext>> sideInput;

        public MapInputToRequest(PCollectionView<Map<T, ImageContext>> sideInput) {
            this.sideInput = sideInput;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            if (this.sideInput != null) {
                Map imageContextMap = (Map)context.sideInput(this.sideInput);
                context.output((Object)AnnotateImages.this.mapToRequest(context.element(), (ImageContext)imageContextMap.get(context.element())));
            } else {
                context.output((Object)AnnotateImages.this.mapToRequest(context.element(), null));
            }
        }
    }

    public static class PerformImageAnnotation
    extends DoFn<KV<Integer, Iterable<AnnotateImageRequest>>, List<AnnotateImageResponse>> {
        private transient ImageAnnotatorClient imageAnnotatorClient;

        public PerformImageAnnotation() {
        }

        public PerformImageAnnotation(ImageAnnotatorClient imageAnnotatorClient) {
            this.imageAnnotatorClient = imageAnnotatorClient;
        }

        @DoFn.Setup
        public void setup() throws IOException {
            this.imageAnnotatorClient = ImageAnnotatorClient.create();
        }

        @DoFn.Teardown
        public void teardown() {
            this.imageAnnotatorClient.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            context.output(this.getResponse(Objects.requireNonNull((Iterable)((KV)context.element()).getValue())));
        }

        List<AnnotateImageResponse> getResponse(Iterable<AnnotateImageRequest> requests) {
            ArrayList requestList = new ArrayList();
            requests.forEach(requestList::add);
            BatchAnnotateImagesResponse batchAnnotateImagesResponse = this.imageAnnotatorClient.batchAnnotateImages(requestList);
            return batchAnnotateImagesResponse.getResponsesList();
        }
    }
}

