/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_json_jackson.com.google.common.base.Optional;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;

public class ParseJsons<OutputT>
extends PTransform<PCollection<String>, PCollection<OutputT>> {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private final Class<? extends OutputT> outputClass;
    private ObjectMapper customMapper;

    public static <OutputT> ParseJsons<OutputT> of(Class<? extends OutputT> outputClass) {
        return new ParseJsons<OutputT>(outputClass);
    }

    private ParseJsons(Class<? extends OutputT> outputClass) {
        this.outputClass = outputClass;
    }

    public ParseJsons<OutputT> withMapper(ObjectMapper mapper) {
        ParseJsons<? extends OutputT> newTransform = new ParseJsons<OutputT>(this.outputClass);
        newTransform.customMapper = mapper;
        return newTransform;
    }

    public PCollection<OutputT> expand(PCollection<String> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, OutputT>(){

            public OutputT apply(String input) {
                try {
                    ObjectMapper mapper = Optional.fromNullable(ParseJsons.this.customMapper).or(DEFAULT_MAPPER);
                    return mapper.readValue(input, ParseJsons.this.outputClass);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse a " + ParseJsons.this.outputClass.getName() + " from JSON value: " + input, e);
                }
            }
        }));
    }
}

