/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_json_jackson.com.google.common.base.Optional;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;

public class AsJsons<InputT>
extends PTransform<PCollection<InputT>, PCollection<String>> {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private final Class<? extends InputT> inputClass;
    private ObjectMapper customMapper;

    public static <OutputT> AsJsons<OutputT> of(Class<? extends OutputT> outputClass) {
        return new AsJsons<OutputT>(outputClass);
    }

    private AsJsons(Class<? extends InputT> outputClass) {
        this.inputClass = outputClass;
    }

    public AsJsons<InputT> withMapper(ObjectMapper mapper) {
        AsJsons<? extends InputT> newTransform = new AsJsons<InputT>(this.inputClass);
        newTransform.customMapper = mapper;
        return newTransform;
    }

    public PCollection<String> expand(PCollection<InputT> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<InputT, String>(){

            public String apply(InputT input) {
                try {
                    ObjectMapper mapper = Optional.fromNullable(AsJsons.this.customMapper).or(DEFAULT_MAPPER);
                    return mapper.writeValueAsString(input);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to serialize " + AsJsons.this.inputClass.getName() + " value: " + input, e);
                }
            }
        }));
    }
}

