/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.jackson.AsJsons;
import org.apache.beam.sdk.extensions.jackson.ParseJsons;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;

public class JacksonTransformsTest {
    private static final List<String> VALID_JSONS = Arrays.asList("{\"myString\":\"abc\",\"myInt\":3}", "{\"myString\":\"def\",\"myInt\":4}");
    private static final List<String> INVALID_JSONS = Arrays.asList("{myString:\"abc\",\"myInt\":3,\"other\":1}", "{", "");
    private static final List<String> EMPTY_JSONS = Arrays.asList("{}", "{}");
    private static final List<String> EXTRA_PROPERTIES_JSONS = Arrays.asList("{\"myString\":\"abc\",\"myInt\":3,\"other\":1}", "{\"myString\":\"def\",\"myInt\":4}");
    private static final List<MyPojo> POJOS = Arrays.asList(new MyPojo("abc", 3), new MyPojo("def", 4));
    private static final List<MyEmptyBean> EMPTY_BEANS = Arrays.asList(new MyEmptyBean("abc", 3), new MyEmptyBean("def", 4));
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void parseValidJsons() {
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(VALID_JSONS))).apply((PTransform)ParseJsons.of(MyPojo.class))).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)output).containsInAnyOrder(POJOS);
        this.pipeline.run();
    }

    @Test(expected=Pipeline.PipelineExecutionException.class)
    public void failParsingInvalidJsons() {
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(VALID_JSONS, INVALID_JSONS)))).apply((PTransform)ParseJsons.of(MyPojo.class))).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)output).containsInAnyOrder(POJOS);
        this.pipeline.run();
    }

    @Test(expected=Pipeline.PipelineExecutionException.class)
    public void failParsingWithoutCustomMapper() {
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(EXTRA_PROPERTIES_JSONS))).apply((PTransform)ParseJsons.of(MyPojo.class))).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)output).empty();
        this.pipeline.run();
    }

    @Test
    public void parseUsingCustomMapper() {
        ObjectMapper customMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(EXTRA_PROPERTIES_JSONS))).apply((PTransform)ParseJsons.of(MyPojo.class).withMapper(customMapper))).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)output).containsInAnyOrder(POJOS);
        this.pipeline.run();
    }

    @Test
    public void writeValidObjects() {
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(POJOS))).apply((PTransform)AsJsons.of(MyPojo.class))).setCoder((Coder)StringUtf8Coder.of());
        PAssert.that((PCollection)output).containsInAnyOrder(VALID_JSONS);
        this.pipeline.run();
    }

    @Test(expected=Pipeline.PipelineExecutionException.class)
    public void failWritingWithoutCustomMapper() {
        ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(EMPTY_BEANS))).apply((PTransform)AsJsons.of(MyEmptyBean.class))).setCoder((Coder)StringUtf8Coder.of());
        this.pipeline.run();
    }

    @Test
    public void writeUsingCustomMapper() {
        ObjectMapper customMapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(EMPTY_BEANS))).apply((PTransform)AsJsons.of(MyEmptyBean.class).withMapper(customMapper))).setCoder((Coder)StringUtf8Coder.of());
        PAssert.that((PCollection)output).containsInAnyOrder(EMPTY_JSONS);
        this.pipeline.run();
    }

    public static class MyEmptyBean
    implements Serializable {
        private String myString;
        private int myInt;

        public MyEmptyBean(String myString, int myInt) {
            this.myString = myString;
            this.myInt = myInt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEmptyBean that = (MyEmptyBean)o;
            if (this.myInt != that.myInt) {
                return false;
            }
            return this.myString != null ? this.myString.equals(that.myString) : that.myString == null;
        }

        public int hashCode() {
            int result = this.myString != null ? this.myString.hashCode() : 0;
            result = 31 * result + this.myInt;
            return result;
        }
    }

    public static class MyPojo
    implements Serializable {
        private String myString;
        private int myInt;

        public MyPojo() {
        }

        public MyPojo(String myString, int myInt) {
            this.myString = myString;
            this.myInt = myInt;
        }

        public String getMyString() {
            return this.myString;
        }

        public void setMyString(String myString) {
            this.myString = myString;
        }

        public int getMyInt() {
            return this.myInt;
        }

        public void setMyInt(int myInt) {
            this.myInt = myInt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyPojo)) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            return this.myInt == myPojo.myInt && (this.myString != null ? this.myString.equals(myPojo.myString) : myPojo.myString == null);
        }

        public int hashCode() {
            int result = this.myString != null ? this.myString.hashCode() : 0;
            result = 31 * result + this.myInt;
            return result;
        }
    }
}

