/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.jackson.AsJsons;
import org.apache.beam.sdk.extensions.jackson.ParseJsons;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class JacksonTransformsTest
implements Serializable {
    private static final List<String> VALID_JSONS = Arrays.asList("{\"myString\":\"abc\",\"myInt\":3}", "{\"myString\":\"def\",\"myInt\":4}");
    private static final List<String> INVALID_JSONS = Arrays.asList("{myString:\"abc\",\"myInt\":3,\"other\":1}", "{", "");
    private static final List<String> EMPTY_JSONS = Arrays.asList("{}", "{}");
    private static final List<String> EXTRA_PROPERTIES_JSONS = Arrays.asList("{\"myString\":\"abc\",\"myInt\":3,\"other\":1}", "{\"myString\":\"def\",\"myInt\":4}");
    private static final List<MyPojo> POJOS = Arrays.asList(new MyPojo("abc", 3), new MyPojo("def", 4));
    private static final List<MyInvalidPojo> INVALID_POJOS = Arrays.asList(new MyInvalidPojo("aaa", 5), new MyInvalidPojo("bbb", 6));
    private static final List<MyEmptyBean> EMPTY_BEANS = Arrays.asList(new MyEmptyBean("abc", 3), new MyEmptyBean("def", 4));
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void parseValidJsons() {
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(VALID_JSONS))).apply((PTransform)ParseJsons.of(MyPojo.class))).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)output).containsInAnyOrder(POJOS);
        this.pipeline.run();
    }

    @Test(expected=Pipeline.PipelineExecutionException.class)
    public void failParsingInvalidJsons() {
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(VALID_JSONS, INVALID_JSONS)))).apply((PTransform)ParseJsons.of(MyPojo.class))).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)output).containsInAnyOrder(POJOS);
        this.pipeline.run();
    }

    @Test
    public void testParsingInvalidJsonsWithFailuresDefaultHandler() {
        WithFailures.Result result = (WithFailures.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(VALID_JSONS, INVALID_JSONS)))).apply((PTransform)ParseJsons.of(MyPojo.class).exceptionsVia());
        ((PCollection)result.output()).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)((PCollection)result.output())).containsInAnyOrder(POJOS);
        this.assertParsingWithErrorMapHandler((WithFailures.Result<PCollection<MyPojo>, KV<String, Map<String, String>>>)result);
        this.pipeline.run();
    }

    @Test
    public void testParsingInvalidJsonsWithFailuresAsMap() {
        WithFailures.Result result = (WithFailures.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(VALID_JSONS, INVALID_JSONS)))).apply((PTransform)ParseJsons.of(MyPojo.class).exceptionsVia((InferableFunction)new WithFailures.ExceptionAsMapHandler<String>(){}));
        ((PCollection)result.output()).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)((PCollection)result.output())).containsInAnyOrder(POJOS);
        this.assertParsingWithErrorMapHandler((WithFailures.Result<PCollection<MyPojo>, KV<String, Map<String, String>>>)result);
        this.pipeline.run();
    }

    @Test
    public void testParsingInvalidJsonsWithFailuresSimpleFunction() {
        WithFailures.Result result = (WithFailures.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(VALID_JSONS, INVALID_JSONS)))).apply((PTransform)ParseJsons.of(MyPojo.class).exceptionsVia((InferableFunction)new SimpleFunction<WithFailures.ExceptionElement<String>, KV<String, String>>(){

            public KV<String, String> apply(WithFailures.ExceptionElement<String> failure) {
                return KV.of((Object)((String)failure.element()), (Object)failure.exception().getClass().getCanonicalName());
            }
        }));
        ((PCollection)result.output()).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)((PCollection)result.output())).containsInAnyOrder(POJOS);
        this.assertParsingWithErrorFunctionHandler((WithFailures.Result<PCollection<MyPojo>, KV<String, String>>)result);
        this.pipeline.run();
    }

    @Test
    public void testParsingInvalidJsonsWithFailuresLambda() {
        WithFailures.Result result = (WithFailures.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(VALID_JSONS, INVALID_JSONS)))).apply((PTransform)ParseJsons.of(MyPojo.class).exceptionsInto(TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.strings())).exceptionsVia((ProcessFunction & Serializable)f -> KV.of((Object)((String)f.element()), (Object)f.exception().getClass().getCanonicalName())));
        ((PCollection)result.output()).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)((PCollection)result.output())).containsInAnyOrder(POJOS);
        this.assertParsingWithErrorFunctionHandler((WithFailures.Result<PCollection<MyPojo>, KV<String, String>>)result);
        this.pipeline.run();
    }

    @Test(expected=Pipeline.PipelineExecutionException.class)
    public void failParsingWithoutCustomMapper() {
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(EXTRA_PROPERTIES_JSONS))).apply((PTransform)ParseJsons.of(MyPojo.class))).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)output).empty();
        this.pipeline.run();
    }

    @Test
    public void parseUsingCustomMapper() {
        ObjectMapper customMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(EXTRA_PROPERTIES_JSONS))).apply((PTransform)ParseJsons.of(MyPojo.class).withMapper(customMapper))).setCoder((Coder)SerializableCoder.of(MyPojo.class));
        PAssert.that((PCollection)output).containsInAnyOrder(POJOS);
        this.pipeline.run();
    }

    @Test
    public void writeValidObjects() {
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(POJOS))).apply((PTransform)AsJsons.of(MyPojo.class))).setCoder((Coder)StringUtf8Coder.of());
        PAssert.that((PCollection)output).containsInAnyOrder(VALID_JSONS);
        this.pipeline.run();
    }

    @Test(expected=Pipeline.PipelineExecutionException.class)
    public void failWritingWithoutCustomMapper() {
        ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(EMPTY_BEANS))).apply((PTransform)AsJsons.of(MyEmptyBean.class))).setCoder((Coder)StringUtf8Coder.of());
        this.pipeline.run();
    }

    @Test
    public void writeUsingCustomMapper() {
        ObjectMapper customMapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        PCollection output = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of(EMPTY_BEANS))).apply((PTransform)AsJsons.of(MyEmptyBean.class).withMapper(customMapper))).setCoder((Coder)StringUtf8Coder.of());
        PAssert.that((PCollection)output).containsInAnyOrder(EMPTY_JSONS);
        this.pipeline.run();
    }

    @Test
    public void testWritingInvalidJsonsWithFailuresDefaultHandler() {
        WithFailures.Result result = (WithFailures.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(POJOS, INVALID_POJOS)).withCoder((Coder)SerializableCoder.of(MyPojo.class)))).apply((PTransform)AsJsons.of(MyPojo.class).exceptionsVia());
        ((PCollection)result.output()).setCoder((Coder)StringUtf8Coder.of());
        result.failures().setCoder((Coder)KvCoder.of((Coder)SerializableCoder.of(MyPojo.class), (Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of())));
        PAssert.that((PCollection)((PCollection)result.output())).containsInAnyOrder(VALID_JSONS);
        this.assertWritingWithErrorMapHandler((WithFailures.Result<PCollection<String>, KV<MyPojo, Map<String, String>>>)result);
        this.pipeline.run();
    }

    @Test
    public void testWritingInvalidJsonsWithFailuresAsMap() {
        WithFailures.Result result = (WithFailures.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(POJOS, INVALID_POJOS)).withCoder((Coder)SerializableCoder.of(MyPojo.class)))).apply((PTransform)AsJsons.of(MyPojo.class).exceptionsVia((InferableFunction)new WithFailures.ExceptionAsMapHandler<MyPojo>(){}));
        ((PCollection)result.output()).setCoder((Coder)StringUtf8Coder.of());
        PAssert.that((PCollection)((PCollection)result.output())).containsInAnyOrder(VALID_JSONS);
        this.assertWritingWithErrorMapHandler((WithFailures.Result<PCollection<String>, KV<MyPojo, Map<String, String>>>)result);
        this.pipeline.run();
    }

    @Test
    public void testWritingInvalidJsonsWithFailuresSimpleFunction() {
        WithFailures.Result result = (WithFailures.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(POJOS, INVALID_POJOS)).withCoder((Coder)SerializableCoder.of(MyPojo.class)))).apply((PTransform)AsJsons.of(MyPojo.class).exceptionsVia((InferableFunction)new SimpleFunction<WithFailures.ExceptionElement<MyPojo>, KV<MyPojo, String>>(){

            public KV<MyPojo, String> apply(WithFailures.ExceptionElement<MyPojo> failure) {
                return KV.of((Object)((MyPojo)failure.element()), (Object)failure.exception().getClass().getCanonicalName());
            }
        }));
        ((PCollection)result.output()).setCoder((Coder)StringUtf8Coder.of());
        PAssert.that((PCollection)((PCollection)result.output())).containsInAnyOrder(VALID_JSONS);
        this.assertWritingWithErrorFunctionHandler((WithFailures.Result<PCollection<String>, KV<MyPojo, String>>)result);
        this.pipeline.run();
    }

    @Test
    public void testWritingInvalidJsonsWithFailuresLambda() {
        WithFailures.Result result = (WithFailures.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Iterable)Iterables.concat(POJOS, INVALID_POJOS)).withCoder((Coder)SerializableCoder.of(MyPojo.class)))).apply((PTransform)AsJsons.of(MyPojo.class).exceptionsInto(TypeDescriptors.kvs((TypeDescriptor)TypeDescriptor.of(MyPojo.class), (TypeDescriptor)TypeDescriptors.strings())).exceptionsVia((ProcessFunction & Serializable)f -> KV.of((Object)((MyPojo)f.element()), (Object)f.exception().getClass().getCanonicalName())));
        ((PCollection)result.output()).setCoder((Coder)StringUtf8Coder.of());
        PAssert.that((PCollection)((PCollection)result.output())).containsInAnyOrder(VALID_JSONS);
        this.assertWritingWithErrorFunctionHandler((WithFailures.Result<PCollection<String>, KV<MyPojo, String>>)result);
        this.pipeline.run();
    }

    private void assertParsingWithErrorMapHandler(WithFailures.Result<PCollection<MyPojo>, KV<String, Map<String, String>>> result) {
        PAssert.that((PCollection)result.failures()).satisfies((SerializableFunction & Serializable)kv -> {
            for (KV entry : kv) {
                if (((String)entry.getKey()).equals(INVALID_JSONS.get(0))) {
                    Assert.assertEquals((Object)"com.fasterxml.jackson.core.JsonParseException", ((Map)entry.getValue()).get("className"));
                } else if (((String)entry.getKey()).equals(INVALID_JSONS.get(1))) {
                    Assert.assertEquals((Object)"com.fasterxml.jackson.core.io.JsonEOFException", ((Map)entry.getValue()).get("className"));
                } else if (((String)entry.getKey()).equals(INVALID_JSONS.get(2))) {
                    Assert.assertEquals((Object)"com.fasterxml.jackson.databind.exc.MismatchedInputException", ((Map)entry.getValue()).get("className"));
                } else {
                    throw new AssertionError((Object)("Unexpected key is found in failures result: \"" + (String)entry.getKey() + "\""));
                }
                MatcherAssert.assertThat(((Map)entry.getValue()).entrySet(), (Matcher)Matchers.hasSize((int)3));
                MatcherAssert.assertThat((Object)((Map)entry.getValue()), (Matcher)Matchers.hasKey((Object)"stackTrace"));
                MatcherAssert.assertThat((Object)((Map)entry.getValue()), (Matcher)Matchers.hasKey((Object)"message"));
            }
            return null;
        });
    }

    private void assertParsingWithErrorFunctionHandler(WithFailures.Result<PCollection<MyPojo>, KV<String, String>> result) {
        PAssert.that((PCollection)result.failures()).containsInAnyOrder((Object[])new KV[]{KV.of((Object)INVALID_JSONS.get(0), (Object)"com.fasterxml.jackson.core.JsonParseException"), KV.of((Object)INVALID_JSONS.get(1), (Object)"com.fasterxml.jackson.core.io.JsonEOFException"), KV.of((Object)INVALID_JSONS.get(2), (Object)"com.fasterxml.jackson.databind.exc.MismatchedInputException")});
    }

    private void assertWritingWithErrorMapHandler(WithFailures.Result<PCollection<String>, KV<MyPojo, Map<String, String>>> result) {
        PAssert.that((PCollection)result.failures()).satisfies((SerializableFunction & Serializable)kv -> {
            for (KV entry : kv) {
                MatcherAssert.assertThat(((Map)entry.getValue()).entrySet(), (Matcher)Matchers.hasSize((int)3));
                MatcherAssert.assertThat((Object)((Map)entry.getValue()), (Matcher)Matchers.hasKey((Object)"stackTrace"));
                MatcherAssert.assertThat((Object)((Map)entry.getValue()), (Matcher)Matchers.hasKey((Object)"message"));
                Assert.assertEquals((Object)"com.fasterxml.jackson.databind.JsonMappingException", ((Map)entry.getValue()).get("className"));
            }
            return null;
        });
    }

    private void assertWritingWithErrorFunctionHandler(WithFailures.Result<PCollection<String>, KV<MyPojo, String>> result) {
        PAssert.that((PCollection)result.failures()).containsInAnyOrder((Object[])new KV[]{KV.of((Object)INVALID_POJOS.get(0), (Object)"com.fasterxml.jackson.databind.JsonMappingException"), KV.of((Object)INVALID_POJOS.get(1), (Object)"com.fasterxml.jackson.databind.JsonMappingException")});
    }

    public static class MyInvalidPojo
    extends MyPojo {
        public MyInvalidPojo(String myString, int myInt) {
            super(myString, myInt);
        }

        @Override
        public String getMyString() {
            throw new RuntimeException("Unknown error!");
        }
    }

    public static class MyEmptyBean
    implements Serializable {
        private String myString;
        private int myInt;

        public MyEmptyBean(String myString, int myInt) {
            this.myString = myString;
            this.myInt = myInt;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEmptyBean that = (MyEmptyBean)o;
            if (this.myInt != that.myInt) {
                return false;
            }
            return this.myString != null ? this.myString.equals(that.myString) : that.myString == null;
        }

        public int hashCode() {
            int result = this.myString != null ? this.myString.hashCode() : 0;
            result = 31 * result + this.myInt;
            return result;
        }
    }

    public static class MyPojo
    implements Serializable {
        private String myString;
        private int myInt;

        public MyPojo() {
        }

        public MyPojo(String myString, int myInt) {
            this.myString = myString;
            this.myInt = myInt;
        }

        public String getMyString() {
            return this.myString;
        }

        public void setMyString(String myString) {
            this.myString = myString;
        }

        public int getMyInt() {
            return this.myInt;
        }

        public void setMyInt(int myInt) {
            this.myInt = myInt;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyPojo)) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            return this.myInt == myPojo.myInt && (this.myString != null ? this.myString.equals(myPojo.myString) : myPojo.myString == null);
        }

        public int hashCode() {
            int result = this.myString != null ? this.myString.hashCode() : 0;
            result = 31 * result + this.myInt;
            return result;
        }
    }
}

