/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.joinlibrary;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.extensions.joinlibrary.Join;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class InnerJoinTest {
    private List<KV<String, Long>> leftListOfKv;
    private List<KV<String, String>> listRightOfKv;
    private List<KV<String, KV<Long, String>>> expectedResult;
    @Rule
    public final transient TestPipeline p = TestPipeline.create();

    @Before
    public void setup() {
        this.leftListOfKv = new ArrayList<KV<String, Long>>();
        this.listRightOfKv = new ArrayList<KV<String, String>>();
        this.expectedResult = new ArrayList<KV<String, KV<Long, String>>>();
    }

    @Test
    public void testJoinOneToOneMapping() {
        this.leftListOfKv.add((KV<String, Long>)KV.of((Object)"Key1", (Object)5L));
        this.leftListOfKv.add((KV<String, Long>)KV.of((Object)"Key2", (Object)4L));
        PCollection leftCollection = (PCollection)this.p.apply("CreateLeft", (PTransform)Create.of(this.leftListOfKv));
        this.listRightOfKv.add((KV<String, String>)KV.of((Object)"Key1", (Object)"foo"));
        this.listRightOfKv.add((KV<String, String>)KV.of((Object)"Key2", (Object)"bar"));
        PCollection rightCollection = (PCollection)this.p.apply("CreateRight", (PTransform)Create.of(this.listRightOfKv));
        PCollection output = Join.innerJoin((PCollection)leftCollection, (PCollection)rightCollection);
        this.expectedResult.add((KV<String, KV<Long, String>>)KV.of((Object)"Key1", (Object)KV.of((Object)5L, (Object)"foo")));
        this.expectedResult.add((KV<String, KV<Long, String>>)KV.of((Object)"Key2", (Object)KV.of((Object)4L, (Object)"bar")));
        PAssert.that((PCollection)output).containsInAnyOrder(this.expectedResult);
        this.p.run();
    }

    @Test
    public void testJoinOneToManyMapping() {
        this.leftListOfKv.add((KV<String, Long>)KV.of((Object)"Key2", (Object)4L));
        PCollection leftCollection = (PCollection)this.p.apply("CreateLeft", (PTransform)Create.of(this.leftListOfKv));
        this.listRightOfKv.add((KV<String, String>)KV.of((Object)"Key2", (Object)"bar"));
        this.listRightOfKv.add((KV<String, String>)KV.of((Object)"Key2", (Object)"gazonk"));
        PCollection rightCollection = (PCollection)this.p.apply("CreateRight", (PTransform)Create.of(this.listRightOfKv));
        PCollection output = Join.innerJoin((PCollection)leftCollection, (PCollection)rightCollection);
        this.expectedResult.add((KV<String, KV<Long, String>>)KV.of((Object)"Key2", (Object)KV.of((Object)4L, (Object)"bar")));
        this.expectedResult.add((KV<String, KV<Long, String>>)KV.of((Object)"Key2", (Object)KV.of((Object)4L, (Object)"gazonk")));
        PAssert.that((PCollection)output).containsInAnyOrder(this.expectedResult);
        this.p.run();
    }

    @Test
    public void testJoinManyToOneMapping() {
        this.leftListOfKv.add((KV<String, Long>)KV.of((Object)"Key2", (Object)4L));
        this.leftListOfKv.add((KV<String, Long>)KV.of((Object)"Key2", (Object)6L));
        PCollection leftCollection = (PCollection)this.p.apply("CreateLeft", (PTransform)Create.of(this.leftListOfKv));
        this.listRightOfKv.add((KV<String, String>)KV.of((Object)"Key2", (Object)"bar"));
        PCollection rightCollection = (PCollection)this.p.apply("CreateRight", (PTransform)Create.of(this.listRightOfKv));
        PCollection output = Join.innerJoin((PCollection)leftCollection, (PCollection)rightCollection);
        this.expectedResult.add((KV<String, KV<Long, String>>)KV.of((Object)"Key2", (Object)KV.of((Object)4L, (Object)"bar")));
        this.expectedResult.add((KV<String, KV<Long, String>>)KV.of((Object)"Key2", (Object)KV.of((Object)6L, (Object)"bar")));
        PAssert.that((PCollection)output).containsInAnyOrder(this.expectedResult);
        this.p.run();
    }

    @Test
    public void testJoinNoneToNoneMapping() {
        this.leftListOfKv.add((KV<String, Long>)KV.of((Object)"Key2", (Object)4L));
        PCollection leftCollection = (PCollection)this.p.apply("CreateLeft", (PTransform)Create.of(this.leftListOfKv));
        this.listRightOfKv.add((KV<String, String>)KV.of((Object)"Key3", (Object)"bar"));
        PCollection rightCollection = (PCollection)this.p.apply("CreateRight", (PTransform)Create.of(this.listRightOfKv));
        PCollection output = Join.innerJoin((PCollection)leftCollection, (PCollection)rightCollection);
        PAssert.that((PCollection)output).containsInAnyOrder(this.expectedResult);
        this.p.run();
    }

    @Test(expected=NullPointerException.class)
    public void testJoinLeftCollectionNull() {
        this.p.enableAbandonedNodeEnforcement(false);
        Join.innerJoin(null, (PCollection)((PCollection)this.p.apply((PTransform)Create.of(this.listRightOfKv).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)StringUtf8Coder.of())))));
    }

    @Test(expected=NullPointerException.class)
    public void testJoinRightCollectionNull() {
        this.p.enableAbandonedNodeEnforcement(false);
        Join.innerJoin((PCollection)((PCollection)this.p.apply((PTransform)Create.of(this.leftListOfKv).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)VarLongCoder.of())))), null);
    }
}

