/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.util;

import java.io.IOException;
import java.util.stream.Stream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IOUtils {
    public static <T> void forEach(@UnknownKeyFor @NonNull @Initialized Iterable<T> iterable, @UnknownKeyFor @NonNull @Initialized IOConsumer<T> consumer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOException firstException = null;
        for (T element : iterable) {
            try {
                consumer.accept(element);
            }
            catch (IOException e) {
                if (firstException != null) {
                    firstException.addSuppressed(e);
                    continue;
                }
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static <T> void forEach(@UnknownKeyFor @NonNull @Initialized Stream<T> stream, @UnknownKeyFor @NonNull @Initialized IOConsumer<T> consumer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.forEach(stream::iterator, consumer);
    }

    @FunctionalInterface
    public static interface IOConsumer<@UnknownKeyFor T> {
        public void accept(T var1) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }
}

