/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CompositeOperator;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Join;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Union;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.CompositeOperatorTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.FlatMapTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.JoinTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.ReduceByKeyTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.TranslatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.translate.UnionTranslator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GenericTranslatorProvider
implements TranslatorProvider {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TranslationDescriptor> possibleTranslators;

    public static @UnknownKeyFor @NonNull @Initialized GenericTranslatorProvider createWithDefaultTranslators() {
        return GenericTranslatorProvider.newBuilder().register(FlatMap.class, new FlatMapTranslator()).register(Union.class, new UnionTranslator()).register(ReduceByKey.class, new ReduceByKeyTranslator()).register(Join.class, new JoinTranslator()).register(op -> op instanceof CompositeOperator, new CompositeOperatorTranslator()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder newBuilder() {
        return new Builder();
    }

    private GenericTranslatorProvider(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TranslationDescriptor> possibleTranslators) {
        this.possibleTranslators = possibleTranslators;
    }

    @Override
    public <InputT, OutputT, OperatorT extends Operator<OutputT>> @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized OperatorTranslator<InputT, OutputT, OperatorT>> findTranslator(OperatorT operator) {
        for (TranslationDescriptor descriptor : this.possibleTranslators) {
            Optional<OperatorTranslator<InputT, OutputT, OperatorT>> maybeTranslator = descriptor.getTranslatorWhenSuitable(operator);
            if (!maybeTranslator.isPresent()) continue;
            return maybeTranslator;
        }
        return Optional.empty();
    }

    private static class TranslationDescriptor<@UnknownKeyFor OperatorT/*
     * Issues handling annotations - annotations may be inaccurate
     */
     extends @UnknownKeyFor @NonNull @Initialized Operator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> {
        private final @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Class<OperatorT>> operatorClass;
        private final @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Predicate<OperatorT>> userDefinedPredicate;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized OperatorTranslator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OperatorT> translator;

        private TranslationDescriptor(@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Class<OperatorT>> operatorClass, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Predicate<OperatorT>> userDefinedPredicate, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized OperatorTranslator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends OperatorT> translator) {
            Preconditions.checkState((operatorClass.isPresent() || userDefinedPredicate.isPresent() ? 1 : 0) != 0, (Object)"At least user defined predicate or class of an operator have to be given.");
            OperatorTranslator<?, ?, ? extends OperatorT> castTranslator = translator;
            this.operatorClass = operatorClass;
            this.userDefinedPredicate = userDefinedPredicate;
            this.translator = castTranslator;
        }

        static <OperatorT extends Operator<?>> @UnknownKeyFor @NonNull @Initialized TranslationDescriptor<OperatorT> of(@UnknownKeyFor @NonNull @Initialized Class<OperatorT> operatorClass, @UnknownKeyFor @NonNull @Initialized Predicate<OperatorT> userDefinedPredicate, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized OperatorTranslator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends OperatorT> translator) {
            return new TranslationDescriptor<OperatorT>(Optional.of(Objects.requireNonNull(operatorClass)), Optional.of(Objects.requireNonNull(userDefinedPredicate)), Objects.requireNonNull(translator));
        }

        static <OperatorT extends Operator<?>> @UnknownKeyFor @NonNull @Initialized TranslationDescriptor<OperatorT> of(@UnknownKeyFor @NonNull @Initialized Predicate<OperatorT> userDefinedPredicate, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized OperatorTranslator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends OperatorT> translator) {
            return new TranslationDescriptor<OperatorT>(Optional.empty(), Optional.of(userDefinedPredicate), Objects.requireNonNull(translator));
        }

        static <OperatorT extends Operator<?>> @UnknownKeyFor @NonNull @Initialized TranslationDescriptor<OperatorT> of(@UnknownKeyFor @NonNull @Initialized Class<OperatorT> operatorClass, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized OperatorTranslator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends OperatorT> translator) {
            return new TranslationDescriptor<OperatorT>(Optional.of(Objects.requireNonNull(operatorClass)), Optional.empty(), Objects.requireNonNull(translator));
        }

        private @UnknownKeyFor @NonNull @Initialized boolean checkTranslatorSuitableFor(OperatorT operator) {
            if (this.operatorClass.isPresent() && !this.operatorClass.get().equals(operator.getClass())) {
                return false;
            }
            if (this.userDefinedPredicate.isPresent() && !this.userDefinedPredicate.get().test(operator)) {
                return false;
            }
            return this.translator.canTranslate(operator);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized OperatorTranslator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OperatorT>> getTranslatorWhenSuitable(OperatorT operator) {
            if (this.checkTranslatorSuitableFor(operator)) {
                return Optional.of(this.translator);
            }
            return Optional.empty();
        }
    }

    public static class Builder {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TranslationDescriptor> possibleTranslators = new ArrayList<TranslationDescriptor>();

        private Builder() {
        }

        public <OperatorT extends Operator<?>> @UnknownKeyFor @NonNull @Initialized Builder register(@UnknownKeyFor @NonNull @Initialized Class<OperatorT> clazz, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized OperatorTranslator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends OperatorT> operatorTranslator) {
            this.possibleTranslators.add(TranslationDescriptor.of(clazz, operatorTranslator));
            return this;
        }

        public <OperatorT extends Operator<?>> @UnknownKeyFor @NonNull @Initialized Builder register(@UnknownKeyFor @NonNull @Initialized Class<OperatorT> clazz, @UnknownKeyFor @NonNull @Initialized Predicate<OperatorT> predicate, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized OperatorTranslator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends OperatorT> operatorTranslator) {
            this.possibleTranslators.add(TranslationDescriptor.of(clazz, predicate, operatorTranslator));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder register(@UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized Operator> predicate, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized OperatorTranslator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Operator> operatorTranslator) {
            this.possibleTranslators.add(TranslationDescriptor.of(predicate, operatorTranslator));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized GenericTranslatorProvider build() {
            return new GenericTranslatorProvider(this.possibleTranslators);
        }
    }
}

