/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate.collector;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Counter;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Histogram;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Timer;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Collector;
import org.apache.beam.sdk.extensions.euphoria.core.client.io.Context;
import org.apache.beam.sdk.extensions.euphoria.core.translate.collector.CollectorAdapter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@NotThreadSafe
public class AdaptableCollector<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor ElemT>
implements Collector<ElemT>,
Context,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized String UNSUPPORTED = "Accumulators are supported for named operators only.";
    private final @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulators;
    private final @UnknownKeyFor @NonNull @Initialized CollectorAdapter<InputT, OutputT, ElemT> adapter;
    private final @Nullable @UnknownKeyFor @Initialized String operatorName;
    private transient // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context;

    public AdaptableCollector(@UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulators, @Nullable @UnknownKeyFor @Initialized String operatorName, @UnknownKeyFor @NonNull @Initialized CollectorAdapter<InputT, OutputT, ElemT> adapter) {
        this.accumulators = accumulators;
        this.operatorName = operatorName;
        this.adapter = adapter;
    }

    @Override
    public void collect(ElemT elem) {
        this.adapter.collect(Objects.requireNonNull(this.context), elem);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Context asContext() {
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Counter getCounter(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.accumulators.getCounter(Objects.requireNonNull(this.operatorName, UNSUPPORTED), name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Histogram getHistogram(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.accumulators.getHistogram(Objects.requireNonNull(this.operatorName, UNSUPPORTED), name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Timer getTimer(@UnknownKeyFor @NonNull @Initialized String name) {
        throw new UnsupportedOperationException("Timer not supported. Use histogram instead.");
    }

    public void setProcessContext(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
        this.context = Objects.requireNonNull(context);
    }
}

