/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TimestampExtractTransform<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
    private final @UnknownKeyFor @NonNull @Initialized PCollectionTransform<InputT, OutputT> timestampedTransform;

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TimestampExtractTransform<InputT, OutputT> of(@UnknownKeyFor @NonNull @Initialized PCollectionTransform<InputT, OutputT> transform) {
        return new TimestampExtractTransform<InputT, OutputT>(null, transform);
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized TimestampExtractTransform<InputT, OutputT> of(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PCollectionTransform<InputT, OutputT> transform) {
        return new TimestampExtractTransform<InputT, OutputT>(name, transform);
    }

    private TimestampExtractTransform(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized PCollectionTransform<InputT, OutputT> timestampedTransform) {
        super(name);
        this.timestampedTransform = timestampedTransform;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        PCollection in = (PCollection)input.apply(this.getName("wrap"), (PTransform)ParDo.of(new Wrap()));
        if (input.getTypeDescriptor() != null) {
            in = in.setTypeDescriptor(TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.longs(), (TypeDescriptor)input.getTypeDescriptor()));
        }
        return (PCollection)this.timestampedTransform.apply(in);
    }

    private @UnknownKeyFor @NonNull @Initialized String getName(@UnknownKeyFor @NonNull @Initialized String suffix) {
        return this.name != null ? this.name + "::" + suffix : suffix;
    }

    private static class Wrap<@UnknownKeyFor T>
    extends DoFn<T, KV<Long, T>> {
        private Wrap() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) {
            ctx.output((Object)KV.of((Object)ctx.timestamp().getMillis(), (Object)ctx.element()));
        }
    }

    @FunctionalInterface
    public static interface PCollectionTransform<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends UnaryFunction<PCollection<KV<Long, InputT>>, PCollection<OutputT>> {
    }
}

