/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.io.Serializable;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.CombinableBinaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ReduceFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.VoidFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.ReduceByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.LazyAccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.collector.AdaptableCollector;
import org.apache.beam.sdk.extensions.euphoria.core.translate.collector.SingleValueCollector;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReduceByKeyTranslator<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor OutputT>
implements OperatorTranslator<InputT, KV<KeyT, OutputT>, ReduceByKey<InputT, KeyT, ValueT, ?, OutputT>> {
    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> translate(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ReduceByKey<InputT, KeyT, ValueT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> operator, @UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        Preconditions.checkState((!operator.getValueComparator().isPresent() ? 1 : 0) != 0, (Object)"Values sorting is not supported.");
        UnaryFunction keyExtractor = operator.getKeyExtractor();
        UnaryFunction<InputT, ValueT> valueExtractor = operator.getValueExtractor();
        PCollection input = operator.getWindow().map(window -> (PCollection)PCollectionLists.getOnlyElement(inputs).apply((PTransform)window)).orElseGet(() -> PCollectionLists.getOnlyElement(inputs));
        MapElements extractor = MapElements.via(new KeyValueExtractor(keyExtractor, valueExtractor));
        PCollection extracted = ((PCollection)input.apply("extract-keys", (PTransform)extractor)).setTypeDescriptor(TypeDescriptors.kvs(TypeAwareness.orObjects(operator.getKeyType()), TypeAwareness.orObjects(operator.getValueType())));
        LazyAccumulatorProvider accumulators = new LazyAccumulatorProvider(AccumulatorProvider.of(inputs.getPipeline()));
        if (operator.isCombinable()) {
            PCollection combined = operator.isCombineFnStyle() ? (PCollection)extracted.apply("combine", (PTransform)Combine.perKey(ReduceByKeyTranslator.asCombineFn(operator))) : (PCollection)extracted.apply("combine", (PTransform)Combine.perKey(ReduceByKeyTranslator.asCombiner(operator.getReducer(), accumulators, operator.getName().orElse(null))));
            PCollection cast = combined;
            return cast.setTypeDescriptor(operator.getOutputType().orElseThrow(() -> new IllegalStateException("Unable to infer output type descriptor.")));
        }
        return ((PCollection)((PCollection)extracted.apply("group", (PTransform)GroupByKey.create())).setTypeDescriptor(TypeDescriptors.kvs(TypeAwareness.orObjects(operator.getKeyType()), (TypeDescriptor)TypeDescriptors.iterables(TypeAwareness.orObjects(operator.getValueType())))).apply("reduce", (PTransform)ParDo.of(new ReduceDoFn(operator.getReducer(), accumulators, operator.getName().orElse(null))))).setTypeDescriptor(operator.getOutputType().orElseThrow(() -> new IllegalStateException("Unable to infer output type descriptor.")));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean canTranslate(@UnknownKeyFor @NonNull @Initialized ReduceByKey operator) {
        return !operator.getValueComparator().isPresent();
    }

    private static <InputT, KeyT, ValueT, AccT, OutputT> // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValueT, AccT, OutputT> asCombineFn(@UnknownKeyFor @NonNull @Initialized ReduceByKey<InputT, KeyT, ValueT, AccT, OutputT> operator) {
        ReduceByKey<InputT, KeyT, ValueT, AccT, OutputT> cast = operator;
        final VoidFunction<AccT> accumulatorFactory = cast.getAccumulatorFactory();
        final BinaryFunction<AccT, ValueT, AccT> accumulate = cast.getAccumulate();
        final CombinableBinaryFunction<AccT> mergeAccumulators = cast.getMergeAccumulators();
        final UnaryFunction<AccT, OutputT> outputFn = cast.getOutputFn();
        final TypeDescriptor<AccT> accumulatorType = cast.getAccumulatorType();
        return new Combine.CombineFn<ValueT, AccT, OutputT>(){

            public AccT createAccumulator() {
                return accumulatorFactory.apply();
            }

            public @UnknownKeyFor @NonNull @Initialized Coder<AccT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<ValueT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
                return registry.getCoder(accumulatorType);
            }

            public AccT addInput(AccT mutableAccumulator, ValueT input) {
                return accumulate.apply(mutableAccumulator, input);
            }

            public AccT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccT> accumulators) {
                Object accumulated = null;
                for (Object o : accumulators) {
                    if (accumulated == null) {
                        accumulated = o;
                        continue;
                    }
                    accumulated = mergeAccumulators.apply(accumulated, o);
                }
                return accumulated;
            }

            public OutputT extractOutput(AccT accumulator) {
                return outputFn.apply(accumulator);
            }
        };
    }

    private static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Iterable<InputT>, InputT> asCombiner(@UnknownKeyFor @NonNull @Initialized ReduceFunctor<InputT, OutputT> reducer, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulatorProvider, @Nullable @UnknownKeyFor @Initialized String operatorName) {
        ReduceFunctor combiner = reducer;
        return (SerializableFunction & Serializable)input -> {
            SingleValueCollector collector = new SingleValueCollector(accumulatorProvider, operatorName);
            combiner.apply(StreamSupport.stream(input.spliterator(), false), collector);
            return collector.get();
        };
    }

    private static class ReduceDoFn<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT, @UnknownKeyFor OutputT>
    extends DoFn<KV<KeyT, Iterable<ValueT>>, KV<KeyT, OutputT>> {
        private final @UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> reducer;
        private final @UnknownKeyFor @NonNull @Initialized AdaptableCollector<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized Iterable<ValueT>>, @UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>, OutputT> collector;

        ReduceDoFn(@UnknownKeyFor @NonNull @Initialized ReduceFunctor<ValueT, OutputT> reducer, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulators, @Nullable @UnknownKeyFor @Initialized String operatorName) {
            this.reducer = reducer;
            this.collector = new AdaptableCollector(accumulators, operatorName, (ctx, out) -> ctx.output((Object)KV.of((Object)((KV)ctx.element()).getKey(), (Object)out)));
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) {
            this.collector.setProcessContext(ctx);
            this.reducer.apply(StreamSupport.stream(Objects.requireNonNull((Iterable)((KV)ctx.element()).getValue()).spliterator(), false), this.collector);
        }
    }

    private static class KeyValueExtractor<@UnknownKeyFor InputT, @UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
    extends SimpleFunction<InputT, KV<KeyT, ValueT>> {
        private final @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor;
        private final @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor;

        KeyValueExtractor(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor, @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, ValueT> valueExtractor) {
            this.keyExtractor = keyExtractor;
            this.valueExtractor = valueExtractor;
        }

        public @UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT> apply(InputT in) {
            return KV.of(this.keyExtractor.apply(in), this.valueExtractor.apply(in));
        }
    }
}

