/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.util.Optional;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.base.Operator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.TranslatorProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class OperatorTransform<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor OperatorT extends @UnknownKeyFor @NonNull @Initialized Operator<OutputT>>
extends PTransform<PCollectionList<InputT>, PCollection<OutputT>> {
    private final OperatorT operator;
    private final @UnknownKeyFor @NonNull @Initialized OperatorTranslator<InputT, OutputT, OperatorT> translator;

    public static <InputT, OutputT, OperatorT extends Operator<OutputT>> @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> apply(OperatorT operator, @UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        Optional maybeTranslator = TranslatorProvider.of(inputs.getPipeline()).findTranslator(operator);
        if (maybeTranslator.isPresent()) {
            PCollection output = (PCollection)inputs.apply(operator.getName().orElseGet(() -> operator.getClass().getName()), new OperatorTransform<InputT, OutputT, OperatorT>(operator, maybeTranslator.orElse(null)));
            Preconditions.checkState((output.getTypeDescriptor() != null ? 1 : 0) != 0, (Object)"Translator should always return a typed PCollection.");
            return output;
        }
        throw new IllegalStateException("Unable to find translator for basic operator [" + operator.getClass() + "] with name [" + (String)operator.getName().orElse(null) + "]");
    }

    private OperatorTransform(OperatorT operator, @UnknownKeyFor @NonNull @Initialized OperatorTranslator<InputT, OutputT, OperatorT> translator) {
        this.operator = operator;
        this.translator = translator;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        return this.translator.translate(this.operator, inputs);
    }

    public OperatorT getOperator() {
        return this.operator;
    }
}

