/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Counter;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Histogram;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Timer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class LazyAccumulatorProvider
implements AccumulatorProvider,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized AccumulatorProvider.Factory factory;
    private transient @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulators;

    LazyAccumulatorProvider(@UnknownKeyFor @NonNull @Initialized AccumulatorProvider.Factory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Counter getCounter(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.getAccumulatorProvider().getCounter(name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Counter getCounter(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return this.getAccumulatorProvider().getCounter(namespace, name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Histogram getHistogram(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.getAccumulatorProvider().getHistogram(name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Histogram getHistogram(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return this.getAccumulatorProvider().getHistogram(namespace, name);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Timer getTimer(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.getAccumulatorProvider().getTimer(name);
    }

    private @UnknownKeyFor @NonNull @Initialized AccumulatorProvider getAccumulatorProvider() {
        if (this.accumulators == null) {
            this.accumulators = this.factory.create();
        }
        return this.accumulators;
    }
}

