/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Join;
import org.apache.beam.sdk.extensions.euphoria.core.translate.AbstractJoinTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.LazyAccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.translate.collector.AdaptableCollector;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JoinTranslator<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
extends AbstractJoinTranslator<LeftT, RightT, KeyT, OutputT> {
    private static <KeyT, LeftT, RightT, OutputT> @UnknownKeyFor @NonNull @Initialized JoinFn<LeftT, RightT, KeyT, OutputT> getJoinFn(@UnknownKeyFor @NonNull @Initialized Join<LeftT, RightT, KeyT, OutputT> operator, @UnknownKeyFor @NonNull @Initialized TupleTag<LeftT> leftTag, @UnknownKeyFor @NonNull @Initialized TupleTag<RightT> rightTag, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulators) {
        BinaryFunctor<LeftT, RightT, OutputT> joiner = operator.getJoiner();
        switch (operator.getType()) {
            case INNER: {
                return new InnerJoinFn(joiner, leftTag, rightTag, operator.getName().orElse(null), accumulators);
            }
            case LEFT: {
                return new LeftOuterJoinFn(joiner, leftTag, rightTag, operator.getName().orElse(null), accumulators);
            }
            case RIGHT: {
                return new RightOuterJoinFn(joiner, leftTag, rightTag, operator.getName().orElse(null), accumulators);
            }
            case FULL: {
                return new FullJoinFn(joiner, leftTag, rightTag, operator.getName().orElse(null), accumulators);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot translate Euphoria '%s' operator to Beam transformations. Given join type '%s' is not supported.", new Object[]{Join.class.getSimpleName(), operator.getType()}));
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> translate(@UnknownKeyFor @NonNull @Initialized Join<LeftT, RightT, KeyT, OutputT> operator, @UnknownKeyFor @NonNull @Initialized PCollection<LeftT> left, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, LeftT>> leftKeyed, @UnknownKeyFor @NonNull @Initialized PCollection<RightT> reight, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, RightT>> rightKeyed) {
        LazyAccumulatorProvider accumulators = new LazyAccumulatorProvider(AccumulatorProvider.of(leftKeyed.getPipeline()));
        TupleTag leftTag = new TupleTag();
        TupleTag rightTag = new TupleTag();
        JoinFn<LeftT, RightT, KeyT, OutputT> joinFn = JoinTranslator.getJoinFn(operator, leftTag, rightTag, accumulators);
        return (PCollection)((PCollection)KeyedPCollectionTuple.of((TupleTag)leftTag, leftKeyed).and(rightTag, rightKeyed).apply("co-group-by-key", (PTransform)CoGroupByKey.create())).apply(joinFn.getFnName(), (PTransform)ParDo.of(joinFn));
    }

    private static class RightOuterJoinFn<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor K, @UnknownKeyFor OutputT>
    extends JoinFn<LeftT, RightT, K, OutputT> {
        RightOuterJoinFn(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner, @UnknownKeyFor @NonNull @Initialized TupleTag<LeftT> leftTag, @UnknownKeyFor @NonNull @Initialized TupleTag<RightT> rightTag, @Nullable @UnknownKeyFor @Initialized String operatorName, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulatorProvider) {
            super(joiner, leftTag, rightTag, operatorName, accumulatorProvider);
        }

        @Override
        void doJoin(@UnknownKeyFor @NonNull @Initialized Iterable<LeftT> left, @UnknownKeyFor @NonNull @Initialized Iterable<RightT> right) {
            for (RightT rightValue : right) {
                if (left.iterator().hasNext()) {
                    for (LeftT leftValue : left) {
                        this.getJoiner().apply(leftValue, rightValue, this.getCollector());
                    }
                    continue;
                }
                this.getJoiner().apply(null, rightValue, this.getCollector());
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getFnName() {
            return "::right-outer-join";
        }
    }

    private static class LeftOuterJoinFn<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor K, @UnknownKeyFor OutputT>
    extends JoinFn<LeftT, RightT, K, OutputT> {
        LeftOuterJoinFn(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner, @UnknownKeyFor @NonNull @Initialized TupleTag<LeftT> leftTag, @UnknownKeyFor @NonNull @Initialized TupleTag<RightT> rightTag, @Nullable @UnknownKeyFor @Initialized String operatorName, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulatorProvider) {
            super(joiner, leftTag, rightTag, operatorName, accumulatorProvider);
        }

        @Override
        void doJoin(@UnknownKeyFor @NonNull @Initialized Iterable<LeftT> left, @UnknownKeyFor @NonNull @Initialized Iterable<RightT> right) {
            for (LeftT leftValue : left) {
                if (right.iterator().hasNext()) {
                    for (RightT rightValue : right) {
                        this.getJoiner().apply(leftValue, rightValue, this.getCollector());
                    }
                    continue;
                }
                this.getJoiner().apply(leftValue, null, this.getCollector());
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getFnName() {
            return "left-outer-join";
        }
    }

    private static class FullJoinFn<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor K, @UnknownKeyFor OutputT>
    extends JoinFn<LeftT, RightT, K, OutputT> {
        FullJoinFn(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner, @UnknownKeyFor @NonNull @Initialized TupleTag<LeftT> leftTag, @UnknownKeyFor @NonNull @Initialized TupleTag<RightT> rightTag, @Nullable @UnknownKeyFor @Initialized String operatorName, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulatorProvider) {
            super(joiner, leftTag, rightTag, operatorName, accumulatorProvider);
        }

        @Override
        void doJoin(@UnknownKeyFor @NonNull @Initialized Iterable<LeftT> left, @UnknownKeyFor @NonNull @Initialized Iterable<RightT> right) {
            block5: {
                boolean rightHasValues;
                block6: {
                    boolean leftHasValues;
                    block4: {
                        leftHasValues = left.iterator().hasNext();
                        rightHasValues = right.iterator().hasNext();
                        if (!leftHasValues || !rightHasValues) break block4;
                        for (RightT rightValue : right) {
                            for (LeftT leftValue : left) {
                                this.getJoiner().apply(leftValue, rightValue, this.getCollector());
                            }
                        }
                        break block5;
                    }
                    if (!leftHasValues) break block6;
                    for (LeftT leftValue : left) {
                        this.getJoiner().apply(leftValue, null, this.getCollector());
                    }
                    break block5;
                }
                if (!rightHasValues) break block5;
                for (RightT rightValue : right) {
                    this.getJoiner().apply(null, rightValue, this.getCollector());
                }
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getFnName() {
            return "full-join";
        }
    }

    private static class InnerJoinFn<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends JoinFn<LeftT, RightT, KeyT, OutputT> {
        InnerJoinFn(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner, @UnknownKeyFor @NonNull @Initialized TupleTag<LeftT> leftTag, @UnknownKeyFor @NonNull @Initialized TupleTag<RightT> rightTag, @Nullable @UnknownKeyFor @Initialized String operatorName, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulatorProvider) {
            super(joiner, leftTag, rightTag, operatorName, accumulatorProvider);
        }

        @Override
        protected void doJoin(@UnknownKeyFor @NonNull @Initialized Iterable<LeftT> left, @UnknownKeyFor @NonNull @Initialized Iterable<RightT> right) {
            for (LeftT leftItem : left) {
                for (RightT rightItem : right) {
                    this.getJoiner().apply(leftItem, rightItem, this.getCollector());
                }
            }
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized String getFnName() {
            return "inner-join";
        }
    }

    private static abstract class JoinFn<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
    extends DoFn<KV<KeyT, CoGbkResult>, KV<KeyT, OutputT>> {
        private final @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<LeftT> leftTag;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<RightT> rightTag;
        private final @UnknownKeyFor @NonNull @Initialized AdaptableCollector<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized CoGbkResult>, @UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>, OutputT> resultsCollector;

        JoinFn(@UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner, @UnknownKeyFor @NonNull @Initialized TupleTag<LeftT> leftTag, @UnknownKeyFor @NonNull @Initialized TupleTag<RightT> rightTag, @Nullable @UnknownKeyFor @Initialized String operatorName, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulatorProvider) {
            this.joiner = joiner;
            this.leftTag = leftTag;
            this.rightTag = rightTag;
            this.resultsCollector = new AdaptableCollector(accumulatorProvider, operatorName, (ctx, elem) -> ctx.output((Object)KV.of((Object)((KV)ctx.element()).getKey(), (Object)elem)));
        }

        @DoFn.ProcessElement
        public final void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized CoGbkResult> element, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) {
            this.getCollector().setProcessContext(ctx);
            this.doJoin(Objects.requireNonNull((CoGbkResult)element.getValue()).getAll(this.leftTag), Objects.requireNonNull((CoGbkResult)element.getValue()).getAll(this.rightTag));
        }

        abstract void doJoin(@UnknownKeyFor @NonNull @Initialized Iterable<LeftT> var1, @UnknownKeyFor @NonNull @Initialized Iterable<RightT> var2);

        abstract @UnknownKeyFor @NonNull @Initialized String getFnName();

        @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> getJoiner() {
            return this.joiner;
        }

        @UnknownKeyFor @NonNull @Initialized AdaptableCollector<@UnknownKeyFor @NonNull @Initialized KV<KeyT, @UnknownKeyFor @NonNull @Initialized CoGbkResult>, @UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>, OutputT> getCollector() {
            return this.resultsCollector;
        }
    }
}

