/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.ExtractEventTime;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.FlatMap;
import org.apache.beam.sdk.extensions.euphoria.core.client.type.TypeAwareness;
import org.apache.beam.sdk.extensions.euphoria.core.client.util.PCollectionLists;
import org.apache.beam.sdk.extensions.euphoria.core.translate.LazyAccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.translate.OperatorTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.collector.AdaptableCollector;
import org.apache.beam.sdk.extensions.euphoria.core.translate.collector.CollectorAdapter;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

public class FlatMapTranslator<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements OperatorTranslator<InputT, OutputT, FlatMap<InputT, OutputT>> {
    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> translate(@UnknownKeyFor @NonNull @Initialized FlatMap<InputT, OutputT> operator, @UnknownKeyFor @NonNull @Initialized PCollectionList<InputT> inputs) {
        LazyAccumulatorProvider accumulators = new LazyAccumulatorProvider(AccumulatorProvider.of(inputs.getPipeline()));
        Mapper<InputT, OutputT> mapper = new Mapper<InputT, OutputT>(operator.getName().orElse(null), operator.getFunctor(), accumulators, operator.getEventTimeExtractor().orElse(null), operator.getAllowedTimestampSkew());
        return ((PCollection)PCollectionLists.getOnlyElement(inputs).apply("mapper", (PTransform)ParDo.of(mapper))).setTypeDescriptor(TypeAwareness.orObjects(operator.getOutputType()));
    }

    private static class Collector<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements CollectorAdapter<InputT, OutputT, OutputT> {
        private final @Nullable @UnknownKeyFor @Initialized ExtractEventTime<InputT> eventTimeExtractor;

        private Collector(@Nullable @UnknownKeyFor @Initialized ExtractEventTime<InputT> eventTimeExtractor) {
            this.eventTimeExtractor = eventTimeExtractor;
        }

        @Override
        public void collect(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx, OutputT out) {
            if (this.eventTimeExtractor != null) {
                Object element = ctx.element();
                ctx.outputWithTimestamp(out, new Instant(this.eventTimeExtractor.extractTimestamp(element)));
            } else {
                ctx.output(out);
            }
        }
    }

    private static class Mapper<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends DoFn<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputT> mapper;
        private final @UnknownKeyFor @NonNull @Initialized AdaptableCollector<InputT, OutputT, OutputT> collector;
        private final @UnknownKeyFor @NonNull @Initialized Duration timestampSkew;

        Mapper(@Nullable @UnknownKeyFor @Initialized String operatorName, @UnknownKeyFor @NonNull @Initialized UnaryFunctor<InputT, OutputT> mapper, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulators, @Nullable @UnknownKeyFor @Initialized ExtractEventTime<InputT> eventTimeExtractor, @UnknownKeyFor @NonNull @Initialized Duration timestampSkew) {
            this.mapper = mapper;
            this.collector = new AdaptableCollector(accumulators, operatorName, new Collector(eventTimeExtractor));
            this.timestampSkew = timestampSkew;
        }

        @DoFn.ProcessElement
        public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) {
            this.collector.setProcessContext(ctx);
            this.mapper.apply(ctx.element(), this.collector);
        }

        public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
            return this.timestampSkew;
        }
    }
}

