/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.util.Objects;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ExtractKey<@UnknownKeyFor KeyT, @UnknownKeyFor ValueT>
extends PTransform<PCollection<ValueT>, PCollection<KV<KeyT, ValueT>>> {
    private final @UnknownKeyFor @NonNull @Initialized UnaryFunction<ValueT, KeyT> keyExtractor;
    private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<KeyT> keyType;

    ExtractKey(@UnknownKeyFor @NonNull @Initialized UnaryFunction<ValueT, KeyT> keyExtractor, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<KeyT> keyType) {
        this.keyExtractor = Objects.requireNonNull(keyExtractor);
        this.keyType = Objects.requireNonNull(keyType);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, ValueT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<ValueT> input) {
        Objects.requireNonNull(input.getTypeDescriptor());
        return ((PCollection)input.apply((PTransform)ParDo.of(new ExtractKeyFn<KeyT, ValueT>(this.keyExtractor)))).setTypeDescriptor(TypeDescriptors.kvs(this.keyType, (TypeDescriptor)input.getTypeDescriptor()));
    }

    private static class ExtractKeyFn<@UnknownKeyFor KeyT, @UnknownKeyFor InputT>
    extends DoFn<InputT, KV<KeyT, InputT>> {
        private final @UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor;

        ExtractKeyFn(@UnknownKeyFor @NonNull @Initialized UnaryFunction<InputT, KeyT> keyExtractor) {
            this.keyExtractor = keyExtractor;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Object element = c.element();
            KeyT key = this.keyExtractor.apply(element);
            c.output((Object)KV.of(key, (Object)element));
        }
    }
}

