/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.util.Collections;
import java.util.Map;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.BinaryFunctor;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.Join;
import org.apache.beam.sdk.extensions.euphoria.core.translate.AbstractJoinTranslator;
import org.apache.beam.sdk.extensions.euphoria.core.translate.LazyAccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.translate.collector.AdaptableCollector;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BroadcastHashJoinTranslator<@UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor KeyT, @UnknownKeyFor OutputT>
extends AbstractJoinTranslator<LeftT, RightT, KeyT, OutputT> {
    @VisibleForTesting
    final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Table<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized UnaryFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, KeyT>, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pViews = HashBasedTable.create();

    @Override
    @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, OutputT>> translate(@UnknownKeyFor @NonNull @Initialized Join<LeftT, RightT, KeyT, OutputT> operator, @UnknownKeyFor @NonNull @Initialized PCollection<LeftT> left, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, LeftT>> leftKeyed, @UnknownKeyFor @NonNull @Initialized PCollection<RightT> right, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, RightT>> rightKeyed) {
        LazyAccumulatorProvider accumulators = new LazyAccumulatorProvider(AccumulatorProvider.of(left.getPipeline()));
        switch (operator.getType()) {
            case LEFT: {
                PCollectionView<Map<KeyT, Iterable<RightT>>> broadcastRight = this.computeViewAsMultimapIfAbsent(right, operator.getRightKeyExtractor(), rightKeyed);
                return (PCollection)leftKeyed.apply((PTransform)ParDo.of(new BroadcastHashLeftJoinFn<KeyT, LeftT, RightT, OutputT>(broadcastRight, operator.getJoiner(), accumulators, operator.getName().orElse(null))).withSideInputs(new PCollectionView[]{broadcastRight}));
            }
            case RIGHT: {
                PCollectionView<Map<KeyT, Iterable<LeftT>>> broadcastLeft = this.computeViewAsMultimapIfAbsent(left, operator.getLeftKeyExtractor(), leftKeyed);
                return (PCollection)rightKeyed.apply((PTransform)ParDo.of(new BroadcastHashRightJoinFn<KeyT, LeftT, RightT, OutputT>(broadcastLeft, operator.getJoiner(), accumulators, operator.getName().orElse(null))).withSideInputs(new PCollectionView[]{broadcastLeft}));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot translate Euphoria '%s' operator to Beam transformations. Given join type '%s' is not supported for BroadcastHashJoin.", new Object[]{Join.class.getSimpleName(), operator.getType()}));
    }

    private <V> @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<KeyT, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> computeViewAsMultimapIfAbsent(@UnknownKeyFor @NonNull @Initialized PCollection<V> pcollection, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnaryFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, KeyT> keyExtractor, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<KeyT, V>> pCollectionToView) {
        PCollectionView view = (PCollectionView)this.pViews.get(pcollection, keyExtractor);
        if (view == null) {
            view = (PCollectionView)pCollectionToView.apply((PTransform)View.asMultimap());
            this.pViews.put(pcollection, keyExtractor, (Object)view);
        }
        PCollectionView ret = view;
        return ret;
    }

    static class BroadcastHashLeftJoinFn<@UnknownKeyFor K, @UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor OutputT>
    extends DoFn<KV<K, LeftT>, KV<K, OutputT>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<RightT>>> smallSideCollection;
        private final @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner;
        private final @UnknownKeyFor @NonNull @Initialized AdaptableCollector<@UnknownKeyFor @NonNull @Initialized KV<K, LeftT>, @UnknownKeyFor @NonNull @Initialized KV<K, OutputT>, OutputT> outCollector;

        BroadcastHashLeftJoinFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<RightT>>> smallSideCollection, @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulators, @Nullable @UnknownKeyFor @Initialized String operatorName) {
            this.smallSideCollection = smallSideCollection;
            this.joiner = joiner;
            this.outCollector = new AdaptableCollector(accumulators, operatorName, (ctx, elem) -> ctx.output((Object)KV.of((Object)((KV)ctx.element()).getKey(), (Object)elem)));
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            KV element = (KV)context.element();
            Object key = element.getKey();
            Map map = (Map)context.sideInput(this.smallSideCollection);
            Iterable rightValues = map.getOrDefault(key, Collections.singletonList(null));
            this.outCollector.setProcessContext(context);
            rightValues.forEach(rightValue -> this.joiner.apply(element.getValue(), rightValue, this.outCollector));
        }
    }

    static class BroadcastHashRightJoinFn<@UnknownKeyFor K, @UnknownKeyFor LeftT, @UnknownKeyFor RightT, @UnknownKeyFor OutputT>
    extends DoFn<KV<K, RightT>, KV<K, OutputT>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<LeftT>>> smallSideCollection;
        private final @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner;
        private final @UnknownKeyFor @NonNull @Initialized AdaptableCollector<@UnknownKeyFor @NonNull @Initialized KV<K, RightT>, @UnknownKeyFor @NonNull @Initialized KV<K, OutputT>, OutputT> outCollector;

        BroadcastHashRightJoinFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<LeftT>>> smallSideCollection, @UnknownKeyFor @NonNull @Initialized BinaryFunctor<LeftT, RightT, OutputT> joiner, @UnknownKeyFor @NonNull @Initialized AccumulatorProvider accumulators, @Nullable @UnknownKeyFor @Initialized String operatorName) {
            this.smallSideCollection = smallSideCollection;
            this.joiner = joiner;
            this.outCollector = new AdaptableCollector(accumulators, operatorName, (ctx, elem) -> ctx.output((Object)KV.of((Object)((KV)ctx.element()).getKey(), (Object)elem)));
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            KV element = (KV)context.element();
            Object key = element.getKey();
            Map map = (Map)context.sideInput(this.smallSideCollection);
            Iterable leftValues = map.getOrDefault(key, Collections.singletonList(null));
            this.outCollector.setProcessContext(context);
            leftValues.forEach(leftValue -> this.joiner.apply(leftValue, element.getValue(), this.outCollector));
        }
    }
}

