/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.euphoria.core.translate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.AccumulatorProvider;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Counter;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Histogram;
import org.apache.beam.sdk.extensions.euphoria.core.client.accumulators.Timer;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamAccumulatorProvider
implements AccumulatorProvider {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BeamAccumulatorProvider.class);
    private static final @UnknownKeyFor @NonNull @Initialized String KEY_METRIC_SEPARATOR = "::";
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Counter> counterMap = new ConcurrentHashMap<String, Counter>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Histogram> histogramMap = new ConcurrentHashMap<String, Histogram>();

    private BeamAccumulatorProvider() {
    }

    public static @UnknownKeyFor @NonNull @Initialized Factory getFactory() {
        return Factory.get();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Counter getCounter(@UnknownKeyFor @NonNull @Initialized String name) {
        throw new UnsupportedOperationException("BeamAccumulatorProvider doesn't support getCounter(String name). Please specify namespace and name.");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Counter getCounter(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return this.counterMap.computeIfAbsent(BeamAccumulatorProvider.getMetricsKey(namespace, name), key -> new BeamMetricsCounter(namespace, name));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Histogram getHistogram(@UnknownKeyFor @NonNull @Initialized String name) {
        throw new UnsupportedOperationException("BeamAccumulatorProvider doesn't support getHistogram(String name). Please specify namespace and name.");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Histogram getHistogram(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return this.histogramMap.computeIfAbsent(BeamAccumulatorProvider.getMetricsKey(namespace, name), key -> new BeamMetricsHistogram(namespace, name));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Timer getTimer(@UnknownKeyFor @NonNull @Initialized String name) {
        throw new UnsupportedOperationException("BeamAccumulatorProvider doesn't support getTimer(String name). Please specify namespace and name.");
    }

    private static @UnknownKeyFor @NonNull @Initialized String getMetricsKey(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
        return namespace.concat(KEY_METRIC_SEPARATOR).concat(name);
    }

    private static abstract class BeamMetrics {
        private final @UnknownKeyFor @NonNull @Initialized String namespace;
        private final @UnknownKeyFor @NonNull @Initialized String name;

        BeamMetrics(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.name;
        }

        public @UnknownKeyFor @NonNull @Initialized String getNamespace() {
            return this.namespace;
        }
    }

    public static class BeamMetricsHistogram
    extends BeamMetrics
    implements Histogram {
        BeamMetricsHistogram(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
            super(namespace, name);
        }

        @Override
        public void add(@UnknownKeyFor @NonNull @Initialized long value) {
            Metrics.distribution((String)this.getNamespace(), (String)this.getName()).update(value);
        }

        @Override
        public void add(@UnknownKeyFor @NonNull @Initialized long value, @UnknownKeyFor @NonNull @Initialized long times) {
            Distribution histogram = Metrics.distribution((String)this.getNamespace(), (String)this.getName());
            for (long i = 0L; i < times; ++i) {
                histogram.update(value);
            }
        }
    }

    public static class BeamMetricsCounter
    extends BeamMetrics
    implements Counter {
        BeamMetricsCounter(@UnknownKeyFor @NonNull @Initialized String namespace, @UnknownKeyFor @NonNull @Initialized String name) {
            super(namespace, name);
        }

        @Override
        public void increment(@UnknownKeyFor @NonNull @Initialized long value) {
            Metrics.counter((String)this.getNamespace(), (String)this.getName()).inc(value);
        }

        @Override
        public void increment() {
            Metrics.counter((String)this.getNamespace(), (String)this.getName()).inc();
        }
    }

    public static class Factory
    implements AccumulatorProvider.Factory {
        private static final @UnknownKeyFor @NonNull @Initialized Factory INSTANCE = new Factory();
        private static final @UnknownKeyFor @NonNull @Initialized AccumulatorProvider PROVIDER = new BeamAccumulatorProvider();
        private static final @UnknownKeyFor @NonNull @Initialized AtomicBoolean isLogged = new AtomicBoolean();

        private Factory() {
        }

        public static @UnknownKeyFor @NonNull @Initialized Factory get() {
            return INSTANCE;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized AccumulatorProvider create() {
            if (isLogged.compareAndSet(false, true)) {
                LOG.info("Using accumulators with BeamAccumulatorProvider");
            }
            return PROVIDER;
        }
    }
}

